/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.edas;

/**
 * EDAS通用配置
 *
 * @author xiaolongzuo
 */
public interface EdasConfiguration {

    /**
     * 获取应用名称
     *
     * @return 应用名称
     */
    String getApplicationName();

    /**
     * 获取命名空间
     *
     * @return 命名空间
     */
    String getNamespace();

    /**
     * 是否开启EDAS
     *
     * @return 是否开启EDAS
     */
    boolean isEnabled();

    /**
     * 获取regionId，一般通过namespace获取。
     *
     * @return regionId
     */
    String getRegionId();

    /**
     * 检查应用名是否有效
     *
     * @return 应用名是否有效
     */
    boolean isApplicationNameValid();
}
