/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.rds.actuate.endpoint;

import com.alibaba.cloud.spring.boot.rds.env.RdsProperties;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancesRequest;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancesResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractInvoker {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected IAcsClient iAcsClient;
    @Autowired
    protected RdsProperties rdsProperties;
    private static Map<String, DescribeDBInstancesResponse.DBInstance> instanceMap;
    private static final long CACHE_TIME = 3600000L;
    private static volatile Long refreshExpire;

    protected <K extends AcsResponse> K invoke(RpcAcsRequest<K> param) {
        try {
            AcsResponse resp = this.iAcsClient.getAcsResponse(param);
            return (K)resp;
        }
        catch (ClientException e) {
            this.log.error("invoke iAcsClient error", (Throwable)e);
            return null;
        }
    }

    protected DescribeDBInstancesResponse.DBInstance getInstance(String instanceId) {
        this.refreshAllInstance();
        return instanceMap.get(instanceId);
    }

    protected List<DescribeDBInstancesResponse.DBInstance> getInstances() {
        this.refreshAllInstance();
        return instanceMap.values().stream().sorted(Comparator.comparing(DescribeDBInstancesResponse.DBInstance::getDBInstanceId)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAllInstance() {
        if (refreshExpire != null && System.currentTimeMillis() < refreshExpire) {
            return;
        }
        Class<AbstractInvoker> clazz = AbstractInvoker.class;
        synchronized (AbstractInvoker.class) {
            if (refreshExpire != null && System.currentTimeMillis() < refreshExpire) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            DescribeDBInstancesRequest request = new DescribeDBInstancesRequest();
            LinkedHashSet<String> allRegionIds = new LinkedHashSet<String>();
            if (this.rdsProperties.getDefaultRegionId() != null && this.rdsProperties.getDefaultRegionId().length() > 0) {
                allRegionIds.add(this.rdsProperties.getDefaultRegionId());
            }
            if (this.rdsProperties.getAllRegionIds() != null && this.rdsProperties.getAllRegionIds().length() > 0) {
                allRegionIds.addAll(Arrays.asList(this.rdsProperties.getAllRegionIds().split(",")));
            }
            ArrayList instances = new ArrayList();
            for (String regionId : allRegionIds) {
                request.setSysRegionId(regionId);
                DescribeDBInstancesResponse resp = (DescribeDBInstancesResponse)this.invoke((RpcAcsRequest)request);
                if (resp == null) continue;
                instances.addAll(resp.getItems());
            }
            instanceMap = instances.stream().collect(Collectors.toMap(DescribeDBInstancesResponse.DBInstance::getDBInstanceId, Function.identity()));
            refreshExpire = System.currentTimeMillis() + 3600000L;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        refreshExpire = null;
    }
}

