/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.rds.actuate.endpoint;

import com.alibaba.cloud.spring.boot.rds.actuate.endpoint.AbstractInvoker;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstanceAttributeRequest;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstanceAttributeResponse;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancesResponse;
import com.aliyuncs.rds.model.v20140815.DescribeDatabasesRequest;
import com.aliyuncs.rds.model.v20140815.DescribeDatabasesResponse;
import com.aliyuncs.rds.model.v20140815.DescribeResourceUsageRequest;
import com.aliyuncs.rds.model.v20140815.DescribeResourceUsageResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="rdsInstances")
public class RdsInstancesEndpoint
extends AbstractInvoker {
    @ReadOperation
    public Map<String, Map<String, Object>> baseInfo() {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        List<DescribeDBInstancesResponse.DBInstance> instances = this.getInstances();
        instances.forEach(instance -> {
            Map<String, Object> dataOfInstance = this.instanceBaseInfo((DescribeDBInstancesResponse.DBInstance)instance);
            dataOfInstance.put("database", this.getDatabases((DescribeDBInstancesResponse.DBInstance)instance));
            dataOfInstance.put("usage", this.getUsageInfo((DescribeDBInstancesResponse.DBInstance)instance));
            map.put(instance.getDBInstanceId(), dataOfInstance);
        });
        this.appendProperties(map, instances);
        return map;
    }

    private Map<String, Object> instanceBaseInfo(DescribeDBInstancesResponse.DBInstance instance) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("ID", instance.getDBInstanceId());
        data.put("Description", instance.getDBInstanceDescription());
        data.put("PayType", instance.getPayType());
        data.put("DBInstanceType", instance.getDBInstanceType());
        data.put("DBInstanceNetType", instance.getDBInstanceNetType());
        data.put("InstanceNetworkType", instance.getInstanceNetworkType());
        data.put("ConnectionMode", instance.getConnectionMode());
        data.put("RegionId", instance.getRegionId());
        data.put("ZoneId", instance.getZoneId());
        data.put("Engine", instance.getEngine());
        data.put("EngineVersion", instance.getEngineVersion());
        return data;
    }

    private Map<String, Object> getUsageInfo(DescribeDBInstancesResponse.DBInstance instance) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        DescribeResourceUsageRequest usageReq = new DescribeResourceUsageRequest();
        usageReq.setDBInstanceId(instance.getDBInstanceId());
        usageReq.setSysRegionId(instance.getRegionId());
        DescribeResourceUsageResponse resp = (DescribeResourceUsageResponse)this.invoke(usageReq);
        data.put("DiskUsed", resp.getDiskUsed());
        data.put("DataSize", resp.getDataSize());
        data.put("LogSize", resp.getLogSize());
        data.put("BackupSize", resp.getBackupSize());
        data.put("BackupOssDataSize", resp.getBackupOssDataSize());
        data.put("BackupOssLogSize", resp.getBackupOssLogSize());
        data.put("SQLSize", resp.getSQLSize());
        data.put("ColdBackupSize", resp.getColdBackupSize());
        return data;
    }

    private List<Map<String, Object>> getDatabases(DescribeDBInstancesResponse.DBInstance instance) {
        DescribeDatabasesRequest req = new DescribeDatabasesRequest();
        req.setDBInstanceId(instance.getDBInstanceId());
        req.setSysRegionId(instance.getRegionId());
        DescribeDatabasesResponse resp = (DescribeDatabasesResponse)this.invoke(req);
        return resp.getDatabases().stream().map(db -> {
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            data.put("DBName", db.getDBName());
            data.put("CharacterSetName", db.getCharacterSetName());
            data.put("DBDescription", db.getDBDescription());
            data.put("DBStatus", db.getDBStatus());
            return data;
        }).collect(Collectors.toList());
    }

    private void appendProperties(Map<String, Map<String, Object>> map, List<DescribeDBInstancesResponse.DBInstance> instances) {
        instances.stream().collect(Collectors.groupingBy(DescribeDBInstancesResponse.DBInstance::getRegionId)).forEach((regionId, list) -> this.setProperties(map, (String)regionId, (List<DescribeDBInstancesResponse.DBInstance>)list));
    }

    private void setProperties(Map<String, Map<String, Object>> map, String regionId, List<DescribeDBInstancesResponse.DBInstance> instances) {
        int end;
        if (instances == null || instances.size() == 0) {
            return;
        }
        DescribeDBInstanceAttributeRequest req = new DescribeDBInstanceAttributeRequest();
        req.setSysRegionId(regionId);
        int idx = 0;
        int batch = 30;
        do {
            end = Math.min(idx + batch, instances.size());
            List<DescribeDBInstancesResponse.DBInstance> subList = instances.subList(idx, end);
            req.setDBInstanceId(subList.stream().map(DescribeDBInstancesResponse.DBInstance::getDBInstanceId).collect(Collectors.joining(",")));
            DescribeDBInstanceAttributeResponse resp = (DescribeDBInstanceAttributeResponse)this.invoke(req);
            Map<Object, Object> propMap = resp == null || resp.getItems() == null ? Collections.emptyMap() : resp.getItems().stream().collect(Collectors.toMap(DescribeDBInstanceAttributeResponse.DBInstanceAttribute::getDBInstanceId, Function.identity()));
            subList.stream().forEach(instance -> {
                Map dataOfInstance = (Map)map.get(instance.getDBInstanceId());
                DescribeDBInstanceAttributeResponse.DBInstanceAttribute prop = (DescribeDBInstanceAttributeResponse.DBInstanceAttribute)propMap.get(instance.getDBInstanceId());
                dataOfInstance.put("properties", prop);
            });
        } while ((idx = end) < instances.size());
    }
}

