/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.rds.actuate.endpoint;

import com.alibaba.cloud.spring.boot.rds.actuate.endpoint.AbstractInvoker;
import com.alibaba.cloud.spring.boot.rds.env.RdsProperties;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancePerformanceRequest;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancePerformanceResponse;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancesResponse;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="rdsPerformance")
public class RdsPerformanceEndpoint
extends AbstractInvoker {
    private static final String MYSQL_DEFAULT_KEYS = "MySQL_NetworkTraffic,MySQL_QPSTPS,MySQL_Sessions,MySQL_InnoDBBufferRatio,MySQL_InnoDBDataReadWriten,MySQL_InnoDBLogRequests,MySQL_InnoDBLogWrites,MySQL_TempDiskTableCreates,MySQL_MyISAMKeyBufferRatio,MySQL_MyISAMKeyReadWrites,MySQL_COMDML,MySQL_RowDML,MySQL_MemCpuUsage,MySQL_IOPS,MySQL_DetailedSpaceUsage,MySQL_CPS,slavestat";
    private static final String SQL_SERVER_DEFAULT_KEYS = "SQLServer_Transactions,SQLServer_Sessions,SQLServer_BufferHit,SQLServer_FullScans,SQLServer_SQLCompilations,SQLServer_CheckPoint,SQLServer_Logins,SQLServer_LockTimeout,SQLServer_Deadlock,SQLServer_LockWaits,SQLServer_NetworkTraffic,SQLServer_QPS,SQLServer_InstanceCPUUsage,SQLServer_IOPS,SQLServer_SpaceUsage";
    private static final String POSTGRE_SQL_DEFAULT_KEYS = "MemoryUsage,CpuUsage,PgSQL_SpaceUsage,PgSQL_IOPS,PgSQL_Session";
    private static final Long TIME_RANGE = 43200000L;
    @Autowired
    private RdsProperties rdsProperties;

    @ReadOperation
    public Map<String, Object> performance() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List<DescribeDBInstancesResponse.DBInstance> instances = this.getInstances();
        instances.forEach(instance -> {
            Map<String, Object> dataOfInstance = this.performanceInfo((DescribeDBInstancesResponse.DBInstance)instance);
            map.put(instance.getDBInstanceId(), dataOfInstance);
        });
        return map;
    }

    @ReadOperation
    public Map<String, Object> performance(@Selector String instanceId) {
        DescribeDBInstancesResponse.DBInstance instance = this.getInstance(instanceId);
        if (instance == null) {
            return null;
        }
        return this.performanceInfo(instance);
    }

    private Map<String, Object> performanceInfo(DescribeDBInstancesResponse.DBInstance instance) {
        String keys = this.getKeys(instance);
        if (keys == null || keys.length() == 0) {
            return Collections.emptyMap();
        }
        Date end = new Date();
        Date start = new Date(end.getTime() - TIME_RANGE);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        DescribeDBInstancePerformanceRequest req = new DescribeDBInstancePerformanceRequest();
        req.setDBInstanceId(instance.getDBInstanceId());
        req.setStartTime(simpleDateFormat.format(start));
        req.setEndTime(simpleDateFormat.format(end));
        req.setKey(keys);
        DescribeDBInstancePerformanceResponse resp = (DescribeDBInstancePerformanceResponse)this.invoke(req);
        if (resp == null) {
            return Collections.emptyMap();
        }
        return resp.getPerformanceKeys().stream().collect(Collectors.toMap(DescribeDBInstancePerformanceResponse.PerformanceKey::getKey, Function.identity(), (x, y) -> x));
    }

    private String getKeys(DescribeDBInstancesResponse.DBInstance instance) {
        String engine;
        if (this.rdsProperties.getPerformanceKey() != null && this.rdsProperties.getPerformanceKey().length() > 0) {
            return this.rdsProperties.getPerformanceKey();
        }
        switch (engine = instance.getEngine()) {
            case "MySQL": {
                return MYSQL_DEFAULT_KEYS;
            }
            case "SQLServer": {
                return SQL_SERVER_DEFAULT_KEYS;
            }
            case "PostgreSQL": {
                return POSTGRE_SQL_DEFAULT_KEYS;
            }
        }
        return null;
    }
}

