/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.rds.actuate.endpoint;

import com.alibaba.cloud.spring.boot.rds.actuate.endpoint.AbstractInvoker;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancesResponse;
import com.aliyuncs.rds.model.v20140815.DescribeSlowLogsRequest;
import com.aliyuncs.rds.model.v20140815.DescribeSlowLogsResponse;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="rdsSlow100")
public class RdsSlowEndpoint
extends AbstractInvoker {
    private static final String TIME_PATTEN = "yyyy-MM-dd'Z'";
    private static final Long TIME_RANGE = 604800000L;

    @ReadOperation
    public Map<String, List<DescribeSlowLogsResponse.SQLSlowLog>> slow() {
        List<DescribeDBInstancesResponse.DBInstance> instances = this.getInstances();
        Map<String, List<DescribeSlowLogsResponse.SQLSlowLog>> map = instances.stream().collect(Collectors.toMap(DescribeDBInstancesResponse.DBInstance::getDBInstanceId, this::slow));
        return map;
    }

    @ReadOperation
    public List<DescribeSlowLogsResponse.SQLSlowLog> slow(@Selector String instanceId) {
        DescribeDBInstancesResponse.DBInstance instance = this.getInstance(instanceId);
        return this.slow(instance);
    }

    @ReadOperation
    public List<DescribeSlowLogsResponse.SQLSlowLog> slow(@Selector String instanceId, @Selector String start, @Selector String end) {
        DescribeDBInstancesResponse.DBInstance instance = this.getInstance(instanceId);
        return this.slow(instance, start, end);
    }

    private List<DescribeSlowLogsResponse.SQLSlowLog> slow(DescribeDBInstancesResponse.DBInstance instance) {
        SimpleDateFormat format = new SimpleDateFormat(TIME_PATTEN);
        Date end = new Date();
        Date start = new Date(end.getTime() - TIME_RANGE);
        return this.slow(instance, format.format(start), format.format(end));
    }

    private List<DescribeSlowLogsResponse.SQLSlowLog> slow(DescribeDBInstancesResponse.DBInstance instance, @Selector String start, @Selector String end) {
        DescribeSlowLogsRequest request = new DescribeSlowLogsRequest();
        request.setDBInstanceId(instance.getDBInstanceId());
        request.setSysRegionId(instance.getRegionId());
        request.setStartTime(start);
        request.setEndTime(end);
        request.setPageNumber(Integer.valueOf(1));
        request.setPageSize(Integer.valueOf(100));
        DescribeSlowLogsResponse resp = (DescribeSlowLogsResponse)this.invoke(request);
        if (resp == null) {
            return Collections.emptyList();
        }
        return resp.getItems();
    }
}

