/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.client;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.client.NacosPropertySourceBuilder;
import com.alibaba.cloud.nacos.parser.NacosDataParserHandler;
import com.alibaba.cloud.nacos.refresh.NacosContextRefresher;
import com.alibaba.nacos.api.config.ConfigService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Order(value=0)
public class NacosPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger log = LoggerFactory.getLogger(NacosPropertySourceLocator.class);
    private static final String NACOS_PROPERTY_SOURCE_NAME = "NACOS";
    private static final String SEP1 = "-";
    private static final String DOT = ".";
    private static final String SHARED_CONFIG_SEPARATOR_CHAR = "[,]";
    private NacosPropertySourceBuilder nacosPropertySourceBuilder;
    private NacosConfigProperties nacosConfigProperties;

    public NacosPropertySourceLocator(NacosConfigProperties nacosConfigProperties) {
        this.nacosConfigProperties = nacosConfigProperties;
    }

    public PropertySource<?> locate(Environment env) {
        ConfigService configService = this.nacosConfigProperties.configServiceInstance();
        if (null == configService) {
            log.warn("no instance of config service found, can't load config from nacos");
            return null;
        }
        long timeout = this.nacosConfigProperties.getTimeout();
        this.nacosPropertySourceBuilder = new NacosPropertySourceBuilder(configService, timeout);
        String name = this.nacosConfigProperties.getName();
        String dataIdPrefix = this.nacosConfigProperties.getPrefix();
        if (StringUtils.isEmpty((Object)dataIdPrefix)) {
            dataIdPrefix = name;
        }
        if (StringUtils.isEmpty((Object)dataIdPrefix)) {
            dataIdPrefix = env.getProperty("spring.application.name");
        }
        CompositePropertySource composite = new CompositePropertySource(NACOS_PROPERTY_SOURCE_NAME);
        this.loadSharedConfiguration(composite);
        this.loadExtConfiguration(composite);
        this.loadApplicationConfiguration(composite, dataIdPrefix, this.nacosConfigProperties, env);
        return composite;
    }

    private void loadSharedConfiguration(CompositePropertySource compositePropertySource) {
        String sharedDataIds = this.nacosConfigProperties.getSharedDataids();
        String refreshDataIds = this.nacosConfigProperties.getRefreshableDataids();
        if (sharedDataIds == null || sharedDataIds.trim().length() == 0) {
            return;
        }
        String[] sharedDataIdArray = sharedDataIds.split(SHARED_CONFIG_SEPARATOR_CHAR);
        NacosPropertySourceLocator.checkDataIdFileExtension(sharedDataIdArray);
        for (int i = 0; i < sharedDataIdArray.length; ++i) {
            String dataId = sharedDataIdArray[i];
            String fileExtension = dataId.substring(dataId.lastIndexOf(DOT) + 1);
            boolean isRefreshable = this.checkDataIdIsRefreshable(refreshDataIds, sharedDataIdArray[i]);
            this.loadNacosDataIfPresent(compositePropertySource, dataId, "DEFAULT_GROUP", fileExtension, isRefreshable);
        }
    }

    private void loadExtConfiguration(CompositePropertySource compositePropertySource) {
        List<NacosConfigProperties.Config> extConfigs = this.nacosConfigProperties.getExtConfig();
        if (CollectionUtils.isEmpty(extConfigs)) {
            return;
        }
        this.checkExtConfiguration(extConfigs);
        for (NacosConfigProperties.Config config : extConfigs) {
            String dataId = config.getDataId();
            String fileExtension = dataId.substring(dataId.lastIndexOf(DOT) + 1);
            this.loadNacosDataIfPresent(compositePropertySource, dataId, config.getGroup(), fileExtension, config.isRefresh());
        }
    }

    private void checkExtConfiguration(List<NacosConfigProperties.Config> extConfigs) {
        String[] dataIds = new String[extConfigs.size()];
        for (int i = 0; i < extConfigs.size(); ++i) {
            String dataId = extConfigs.get(i).getDataId();
            if (dataId == null || dataId.trim().length() == 0) {
                throw new IllegalStateException(String.format("the [ spring.cloud.nacos.config.ext-config[%s] ] must give a dataId", i));
            }
            dataIds[i] = dataId;
        }
        NacosPropertySourceLocator.checkDataIdFileExtension(dataIds);
    }

    private void loadApplicationConfiguration(CompositePropertySource compositePropertySource, String dataIdPrefix, NacosConfigProperties properties, Environment environment) {
        String fileExtension = properties.getFileExtension();
        String nacosGroup = properties.getGroup();
        this.loadNacosDataIfPresent(compositePropertySource, dataIdPrefix, nacosGroup, fileExtension, true);
        this.loadNacosDataIfPresent(compositePropertySource, dataIdPrefix + DOT + fileExtension, nacosGroup, fileExtension, true);
        for (String profile : environment.getActiveProfiles()) {
            String dataId = dataIdPrefix + SEP1 + profile + DOT + fileExtension;
            this.loadNacosDataIfPresent(compositePropertySource, dataId, nacosGroup, fileExtension, true);
        }
    }

    private void loadNacosDataIfPresent(CompositePropertySource composite, String dataId, String group, String fileExtension, boolean isRefreshable) {
        if (null == dataId || dataId.trim().length() < 1) {
            return;
        }
        if (null == group || group.trim().length() < 1) {
            return;
        }
        NacosPropertySource propertySource = this.loadNacosPropertySource(dataId, group, fileExtension, isRefreshable);
        this.addFirstPropertySource(composite, propertySource, false);
    }

    private NacosPropertySource loadNacosPropertySource(String dataId, String group, String fileExtension, boolean isRefreshable) {
        if (NacosContextRefresher.getRefreshCount() != 0L && !isRefreshable) {
            return NacosPropertySourceRepository.getNacosPropertySource(dataId);
        }
        return this.nacosPropertySourceBuilder.build(dataId, group, fileExtension, isRefreshable);
    }

    private void addFirstPropertySource(CompositePropertySource composite, NacosPropertySource nacosPropertySource, boolean ignoreEmpty) {
        if (null == nacosPropertySource || null == composite) {
            return;
        }
        if (ignoreEmpty && ((Map)nacosPropertySource.getSource()).isEmpty()) {
            return;
        }
        composite.addFirstPropertySource((PropertySource)nacosPropertySource);
    }

    private static void checkDataIdFileExtension(String[] dataIdArray) {
        if (dataIdArray == null || dataIdArray.length < 1) {
            throw new IllegalStateException("The dataId cannot be empty");
        }
        NacosDataParserHandler.getInstance().checkDataId(dataIdArray);
    }

    private boolean checkDataIdIsRefreshable(String refreshDataIds, String sharedDataId) {
        String[] refreshDataIdArray;
        if (StringUtils.isEmpty((Object)refreshDataIds)) {
            return false;
        }
        for (String refreshDataId : refreshDataIdArray = refreshDataIds.split(SHARED_CONFIG_SEPARATOR_CHAR)) {
            if (!refreshDataId.equals(sharedDataId)) continue;
            return true;
        }
        return false;
    }
}

