/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.nacos.parser.NacosByteArrayResource;
import com.alibaba.cloud.nacos.utils.NacosConfigUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class NacosDataParserHandler {
    private static final String DEFAULT_EXTENSION = "properties";
    private static List<PropertySourceLoader> propertySourceLoaders;

    private NacosDataParserHandler() {
        propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
    }

    public List<PropertySource<?>> parseNacosData(String configName, String configValue, String extension) throws IOException {
        if (StringUtils.isEmpty((Object)configValue)) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((Object)extension)) {
            extension = this.getFileExtension(configName);
        }
        for (PropertySourceLoader propertySourceLoader : propertySourceLoaders) {
            if (!this.canLoadFileExtension(propertySourceLoader, extension)) continue;
            NacosByteArrayResource nacosByteArrayResource = propertySourceLoader instanceof PropertiesPropertySourceLoader ? new NacosByteArrayResource(NacosConfigUtils.selectiveConvertUnicode(configValue).getBytes(), configName) : new NacosByteArrayResource(configValue.getBytes(), configName);
            nacosByteArrayResource.setFilename(this.getFileName(configName, extension));
            List propertySourceList = propertySourceLoader.load(configName, (Resource)nacosByteArrayResource);
            if (CollectionUtils.isEmpty((Collection)propertySourceList)) {
                return Collections.emptyList();
            }
            return propertySourceList.stream().filter(Objects::nonNull).map(propertySource -> {
                String[] propertyNames;
                if (propertySource instanceof EnumerablePropertySource && (propertyNames = ((EnumerablePropertySource)propertySource).getPropertyNames()) != null && propertyNames.length > 0) {
                    LinkedHashMap map = new LinkedHashMap();
                    Arrays.stream(propertyNames).forEach(name -> map.put(name, propertySource.getProperty(name)));
                    return new OriginTrackedMapPropertySource(propertySource.getName(), map);
                }
                return propertySource;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean canLoadFileExtension(PropertySourceLoader loader, String extension) {
        return Arrays.stream(loader.getFileExtensions()).anyMatch(fileExtension -> StringUtils.endsWithIgnoreCase((String)extension, (String)fileExtension));
    }

    public String getFileExtension(String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return DEFAULT_EXTENSION;
        }
        int idx = name.lastIndexOf(".");
        if (idx > 0 && idx < name.length() - 1) {
            return name.substring(idx + 1);
        }
        return DEFAULT_EXTENSION;
    }

    private String getFileName(String name, String extension) {
        String ext;
        if (StringUtils.isEmpty((Object)extension)) {
            return name;
        }
        if (StringUtils.isEmpty((Object)name)) {
            return extension;
        }
        int idx = name.lastIndexOf(".");
        if (idx > 0 && idx < name.length() - 1 && extension.equalsIgnoreCase(ext = name.substring(idx + 1))) {
            return name;
        }
        return name + "." + extension;
    }

    public static NacosDataParserHandler getInstance() {
        return ParserHandler.HANDLER;
    }

    private static class ParserHandler {
        private static final NacosDataParserHandler HANDLER = new NacosDataParserHandler();

        private ParserHandler() {
        }
    }
}

