/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.loadbalancer;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.loadbalancer.ConditionalOnLoadBalancerNacos;
import com.alibaba.cloud.nacos.loadbalancer.LoadBalancerAlgorithm;
import com.alibaba.cloud.nacos.loadbalancer.NacosLoadBalancer;
import com.alibaba.cloud.nacos.loadbalancer.ServiceInstanceFilter;
import com.alibaba.cloud.nacos.util.InetIPv6Utils;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnLoadBalancerNacos
@ConditionalOnDiscoveryEnabled
public class NacosLoadBalancerClientConfiguration {
    private static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 183827465;

    @Bean
    @ConditionalOnMissingBean
    public ReactorLoadBalancer<ServiceInstance> nacosLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, NacosDiscoveryProperties nacosDiscoveryProperties, InetIPv6Utils inetIPv6Utils, List<ServiceInstanceFilter> serviceInstanceFilters, List<LoadBalancerAlgorithm> loadBalancerAlgorithms) {
        String name = environment.getProperty("loadbalancer.client.name");
        HashMap<String, LoadBalancerAlgorithm> loadBalancerAlgorithmMap = new HashMap<String, LoadBalancerAlgorithm>();
        loadBalancerAlgorithms.forEach(loadBalancerAlgorithm -> {
            if (!loadBalancerAlgorithmMap.containsKey(loadBalancerAlgorithm.getServiceId())) {
                loadBalancerAlgorithmMap.put(loadBalancerAlgorithm.getServiceId(), (LoadBalancerAlgorithm)loadBalancerAlgorithm);
            }
        });
        return new NacosLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name, nacosDiscoveryProperties, inetIPv6Utils, serviceInstanceFilters, loadBalancerAlgorithmMap);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @Order(value=183827466)
    public static class BlockingSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="default", matchIfMissing=true)
        public ServiceInstanceListSupplier discoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().build(context);
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="zone-preference")
        public ServiceInstanceListSupplier zonePreferenceDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withZonePreference().build(context);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReactiveDiscoveryEnabled
    @Order(value=183827465)
    public static class ReactiveSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="default", matchIfMissing=true)
        public ServiceInstanceListSupplier discoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().build(context);
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="zone-preference")
        public ServiceInstanceListSupplier zonePreferenceDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return ServiceInstanceListSupplier.builder().withDiscoveryClient().withZonePreference().build(context);
        }
    }
}

