/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http.matcher;

import com.alibaba.cloud.dubbo.http.matcher.AbstractHttpRequestMatcher;
import com.alibaba.cloud.dubbo.http.matcher.HttpRequestMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.HttpRequest;

public abstract class CompositeHttpRequestMatcher
extends AbstractHttpRequestMatcher {
    private final List<HttpRequestMatcher> matchers = new LinkedList<HttpRequestMatcher>();

    public CompositeHttpRequestMatcher(HttpRequestMatcher ... matchers) {
        this.matchers.addAll(Arrays.asList(matchers));
    }

    public CompositeHttpRequestMatcher and(HttpRequestMatcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    @Override
    public boolean match(HttpRequest request) {
        for (HttpRequestMatcher matcher : this.matchers) {
            if (matcher.match(request)) continue;
            return false;
        }
        return true;
    }

    protected List<HttpRequestMatcher> getMatchers() {
        return this.matchers;
    }

    @Override
    protected Collection<?> getContent() {
        LinkedList content = new LinkedList();
        for (HttpRequestMatcher matcher : this.getMatchers()) {
            if (!(matcher instanceof AbstractHttpRequestMatcher)) continue;
            content.addAll(((AbstractHttpRequestMatcher)matcher).getContent());
        }
        return content;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }
}

