/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http.matcher;

import com.alibaba.cloud.dubbo.http.matcher.AbstractHttpRequestMatcher;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.util.StringUtils;

public class HttpRequestMethodsMatcher
extends AbstractHttpRequestMatcher {
    private final Set<HttpMethod> methods;

    public HttpRequestMethodsMatcher(String ... methods) {
        this.methods = this.resolveHttpMethods(methods);
    }

    private Set<HttpMethod> resolveHttpMethods(String[] methods) {
        LinkedHashSet<HttpMethod> httpMethods = new LinkedHashSet<HttpMethod>(methods.length);
        for (String method : methods) {
            if (!StringUtils.hasText((String)method)) continue;
            HttpMethod httpMethod = HttpMethod.resolve((String)method);
            httpMethods.add(httpMethod);
        }
        return httpMethods;
    }

    public Set<HttpMethod> getMethods() {
        return this.methods;
    }

    @Override
    public boolean match(HttpRequest request) {
        boolean matched = false;
        HttpMethod httpMethod = request.getMethod();
        if (httpMethod != null) {
            for (HttpMethod method : this.getMethods()) {
                if (!httpMethod.equals((Object)method)) continue;
                matched = true;
                break;
            }
        }
        return matched;
    }

    protected Collection<HttpMethod> getContent() {
        return this.methods;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }
}

