/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk.security;

import com.alibaba.csb.sdk.security.ParamNode;
import com.alibaba.csb.sdk.security.SpasSigner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SignUtil {
    private static List<ParamNode> convertSingleValueParms(Map<String, String> map) {
        ArrayList<ParamNode> pnList = new ArrayList<ParamNode>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            ParamNode node = new ParamNode(key, entry.getValue());
            pnList.add(node);
        }
        return pnList;
    }

    private static List<ParamNode> convertMultiValueParams(Map<String, List<String>> map) {
        ArrayList<ParamNode> pnList = new ArrayList<ParamNode>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<String> vlist = entry.getValue();
            if (vlist == null) {
                ParamNode node = new ParamNode(key, null);
                pnList.add(node);
                continue;
            }
            for (String v : vlist) {
                ParamNode node = new ParamNode(key, v);
                pnList.add(node);
            }
        }
        return pnList;
    }

    public static String sign(Map<String, String> paramsMap, String secretKey) {
        List<ParamNode> paramNodeList = SignUtil.convertSingleValueParms(paramsMap);
        return SignUtil.sign(paramNodeList, secretKey);
    }

    public static String signMultiValueParams(Map<String, List<String>> newParamsMap, String secretKey) {
        List<ParamNode> paramNodeList = SignUtil.convertMultiValueParams(newParamsMap);
        return SignUtil.sign(paramNodeList, secretKey);
    }

    private static String sign(List<ParamNode> paramNodeList, String secretKey) {
        if (paramNodeList == null) {
            paramNodeList = new ArrayList<ParamNode>();
        }
        return SpasSigner.sign(paramNodeList, secretKey);
    }
}

