/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk;

import com.alibaba.csb.sdk.ContentBody;
import com.alibaba.csb.sdk.ContentEncoding;
import com.alibaba.csb.sdk.HttpCaller;
import com.alibaba.csb.sdk.internel.HttpClientHelper;
import com.alibaba.csb.sdk.security.SpasSigner;
import com.alibaba.csb.trace.TraceData;
import com.alibaba.csb.trace.TraceFactory;
import com.alibaba.csb.utils.LogUtils;
import com.alibaba.csb.utils.TraceIdUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.entity.ContentType;

public class HttpParameters {
    public static final long MAX_FILE_AMOUNT = Integer.getInteger("csb_httpAttachmentMaxAmount", 5).intValue();
    private Builder builder;

    String getApi() {
        return this.builder.api;
    }

    String getVersion() {
        return this.builder.version;
    }

    String getAccessKey() {
        return this.builder.ak;
    }

    String getSecretkey() {
        return this.builder.sk;
    }

    String getMethod() {
        return this.builder.method;
    }

    String getRequestUrl() {
        return this.builder.requestUrl;
    }

    ContentBody getContentBody() {
        return this.builder.contentBody;
    }

    ContentType getContentType() {
        return this.builder.contentType;
    }

    Map<String, AttachFile> getAttachFileMap() {
        return this.builder.attatchFileMap;
    }

    String getRestfulProtocolVersion() {
        return this.builder.restfulProtocolVersion;
    }

    public Map<String, List<String>> getParamsMap() {
        return this.builder.paramsMap;
    }

    ContentEncoding getContentEncoding() {
        return this.builder.contentEncoding;
    }

    public Map<String, String> getHeaderParamsMap() {
        return this.builder.headerParamsMap;
    }

    boolean isNonce() {
        return this.builder.nonce;
    }

    boolean isSignContentBody() {
        return this.builder.signContentBody;
    }

    boolean isTimestamp() {
        return this.builder.timestamp;
    }

    boolean isDiagnostic() {
        return this.builder.diagnostic;
    }

    public String getSignImpl() {
        return this.builder.signImpl;
    }

    public String getVerifySignImpl() {
        return this.builder.verifySignImpl;
    }

    public String getSignAlgorithm() {
        return this.builder.getSignAlgorithm();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("requestUrl=").append(this.getRequestUrl());
        sb.append("\n api=").append(this.getApi());
        sb.append("\n version=").append(this.getVersion());
        sb.append("\n method=").append(this.getMethod());
        sb.append("\n accessKey=").append(this.getAccessKey());
        sb.append("\n secretKey=").append("*********");
        sb.append("\n contentBody=").append(this.getContentBody());
        sb.append("\n Nonce=").append(this.isNonce());
        sb.append("\n Timestamp=").append(this.isTimestamp());
        sb.append("\n signImpl=").append(this.getSignImpl());
        sb.append("\n verifySignImpl=").append(this.getVerifySignImpl());
        sb.append("\n isDiagnostic=").append(this.isDiagnostic());
        sb.append("\n params: \n");
        for (Map.Entry entry : this.builder.paramsMap.entrySet()) {
            sb.append((String)entry.getKey()).append("=");
            Object value = entry.getValue();
            if (value instanceof String) {
                sb.append(value);
            } else if (value instanceof String[]) {
                sb.append(Arrays.toString((String[])value));
            } else if (value instanceof List) {
                sb.append(value);
            }
            sb.append("\n");
        }
        sb.append("\n http header params: \n");
        for (Map.Entry entry : this.builder.headerParamsMap.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private HttpParameters(Builder builder) {
        this.builder = builder;
    }

    public static Builder newBuilder() {
        return new Builder().addTraceHeader();
    }

    public void validate() {
        if (this.getRequestUrl() == null) {
            throw new IllegalArgumentException("Bad httpparameters: null requestUrl!");
        }
        String api = this.getApi();
        String version = this.getVersion();
        if (api == null) {
            try {
                String[] path;
                URI uri = new URI(this.getRequestUrl().matches("https?://.+") ? this.getRequestUrl() : "http://" + this.getRequestUrl());
                String query = uri.getQuery();
                if (query != null && !"".equals(query.trim())) {
                    String[] params;
                    for (String p : params = query.split("&")) {
                        if (p.startsWith("_api_name=")) {
                            api = p.substring(10);
                        }
                        if (!p.startsWith("_api_version=")) continue;
                        version = p.substring(13);
                    }
                }
                if ((api == null || "".equals(api.trim())) && (path = uri.getPath().split("/")).length >= 3) {
                    api = path[2];
                    version = path[1];
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (api == null || "".equals(api.trim())) {
            throw new IllegalArgumentException("Bad httpparameters: null api!");
        }
        if (version == null || "".equals(version.trim())) {
            throw new IllegalArgumentException("Bad httpparameters: null version!");
        }
        if (this.getContentBody() != null) {
            if (!"post".equalsIgnoreCase(this.getMethod())) {
                throw new IllegalArgumentException("Bad httpparameters: method must be \"post\" when contentBody is set!");
            }
            if (this.getParamsMap() == null || this.getParamsMap().size() > 0) {
                // empty if block
            }
        }
        this.builder.api = HttpClientHelper.trimWhiteSpaces(api);
        this.builder.version = HttpClientHelper.trimWhiteSpaces(version);
        this.builder.ak = HttpClientHelper.trimWhiteSpaces(this.getAccessKey());
        this.builder.sk = HttpClientHelper.trimWhiteSpaces(this.getSecretkey());
    }

    public static class Builder {
        private String api;
        private String version;
        private String ak;
        private String sk;
        private String restfulProtocolVersion;
        private String method = "POST";
        private ContentType contentType;
        private ContentBody contentBody = null;
        private Map<String, AttachFile> attatchFileMap;
        private String requestUrl;
        private String signImpl;
        private String verifySignImpl;
        private boolean nonce;
        private boolean timestamp = true;
        private boolean signContentBody;
        private Map<String, List<String>> paramsMap = new HashMap<String, List<String>>();
        private ContentEncoding contentEncoding;
        private Map<String, String> headerParamsMap = new HashMap<String, String>();
        private boolean diagnostic = false;
        private HttpServletRequest request;
        private boolean overrideBizId = false;

        public Builder() {
            this.signContentBody = Boolean.parseBoolean(System.getProperty("csb_sign_content_body", "false"));
            this.headerParamsMap.put("Accept-Encoding", "gzip");
        }

        public Builder copy() {
            Builder builder = HttpParameters.newBuilder();
            builder.api = this.api;
            builder.version = this.version;
            builder.ak = this.ak;
            builder.sk = this.sk;
            builder.restfulProtocolVersion = this.restfulProtocolVersion;
            builder.method = this.method;
            builder.contentType = this.contentType;
            builder.contentBody = this.contentBody;
            builder.attatchFileMap = this.attatchFileMap;
            builder.requestUrl = this.requestUrl;
            builder.signImpl = this.signImpl;
            builder.verifySignImpl = this.verifySignImpl;
            builder.nonce = this.nonce;
            builder.timestamp = this.timestamp;
            builder.signContentBody = this.signContentBody;
            builder.paramsMap = new HashMap<String, List<String>>(this.paramsMap);
            builder.contentEncoding = this.contentEncoding;
            builder.headerParamsMap = new HashMap<String, String>(this.headerParamsMap);
            builder.diagnostic = this.diagnostic;
            builder.request = this.request;
            builder.overrideBizId = this.overrideBizId;
            return builder;
        }

        public Builder setContentEncoding(ContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder addAttachFile(String key, String fileName, InputStream inputStream) {
            return this.addAttachFile(key, fileName, inputStream, null);
        }

        public Builder addAttachFile(String key, File file) {
            return this.addAttachFile(key, file, null);
        }

        public Builder addAttachFile(String key, File file, ContentEncoding contentEncoding) {
            if (file == null) {
                throw new IllegalArgumentException("file\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            return this.addAttachFile(key, file.getName(), HttpCaller.readFile(file), contentEncoding);
        }

        public Builder addAttachFile(String key, String fileName, InputStream inputStream, ContentEncoding contentEncoding) {
            if (inputStream == null) {
                throw new IllegalArgumentException("file\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            return this.addAttachFile(key, fileName, HttpCaller.readInputStream(inputStream), contentEncoding);
        }

        private Builder addAttachFile(String key, String fileName, byte[] bytes, ContentEncoding contentEncoding) {
            if (!this.method.equalsIgnoreCase("POST")) {
                throw new IllegalArgumentException("\u53d1\u9001\u9644\u4ef6\u5fc5\u987b\u4f7f\u7528POST");
            }
            if (this.contentBody != null) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u540c\u65f6\u53d1\u9001 contentBody \u548c \u6587\u4ef6");
            }
            if (bytes == null) {
                throw new IllegalArgumentException("file\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (key == null) {
                throw new IllegalArgumentException("key\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (fileName == null) {
                throw new IllegalArgumentException("fileName\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            if (this.attatchFileMap == null) {
                this.attatchFileMap = new HashMap<String, AttachFile>();
            }
            if ((long)this.attatchFileMap.size() >= MAX_FILE_AMOUNT) {
                throw new IllegalArgumentException("\u9644\u4ef6\u6570\u91cf\u8d85\u8fc7\u9650\u5236");
            }
            if ((long)(this.getTotalFileSize() + bytes.length) > HttpCaller.TOTAL_FILE_SIZE) {
                throw new IllegalArgumentException("attach file is too large exceed the MAX-SIZE");
            }
            this.attatchFileMap.put(key, new AttachFile(fileName, bytes, contentEncoding));
            return this;
        }

        public int getTotalFileSize() {
            int totalSize = 0;
            if (this.attatchFileMap != null) {
                for (Map.Entry<String, AttachFile> stringAttachFileEntry : this.attatchFileMap.entrySet()) {
                    totalSize += stringAttachFileEntry.getValue().fileBytes.length;
                }
            }
            return totalSize;
        }

        public Builder api(String api) {
            this.api = api;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder accessKey(String ak) {
            this.ak = ak;
            return this;
        }

        public Builder secretKey(String sk) {
            this.sk = sk;
            return this;
        }

        public Builder bizId(String bizId) {
            if (bizId == null) {
                return this;
            }
            if (!this.headerParamsMap.containsKey(HttpCaller.bizIdKey())) {
                this.putHeaderParamsMap(HttpCaller.bizIdKey(), bizId);
            }
            return this;
        }

        public Builder setBizId(String bizId) {
            this.putHeaderParamsMap(HttpCaller.bizIdKey(), bizId);
            this.overrideBizId = true;
            return this;
        }

        public Builder requestId(String requestId) {
            this.putHeaderParamsMap("_inner_ecsb_request_id", requestId);
            return this;
        }

        public Builder signAlgorithm(SpasSigner.SigningAlgorithm signAlgorithm) {
            this.putHeaderParamsMap("_api_sign_algorithm", signAlgorithm.name());
            return this;
        }

        public Builder setRequest(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        public Builder trace(HttpServletRequest request) {
            return this.setRequest(request).trace();
        }

        public Builder trace() {
            if (TraceFactory.getTraceData() != null) {
                LogUtils.warn("you have turned on filter mode without call the trace method", new Object[0]);
                return this;
            }
            if (this.request == null) {
                LogUtils.error("to enable tracing, you need to call the setRequest method or turn on the filter mode.", new Object[0]);
                throw new RuntimeException("to enable trace, you need to call setRequest method or turned on filter mode.");
            }
            String traceId = this.request.getHeader("_inner_ecsb_trace_id");
            String rpcId = this.request.getHeader("_inner_ecsb_rpc_id");
            String bizId = this.request.getHeader(HttpCaller.bizIdKey());
            this.putHeaderParamsMap("_inner_ecsb_trace_id", traceId != null ? traceId : TraceIdUtils.generate());
            this.putHeaderParamsMap("_inner_ecsb_rpc_id", rpcId != null ? rpcId : "0");
            if (!this.overrideBizId && bizId != null && !bizId.trim().equals("")) {
                this.putHeaderParamsMap(HttpCaller.bizIdKey(), bizId);
            }
            return this;
        }

        public Builder addTraceHeader() {
            this.requestId(TraceIdUtils.generate());
            TraceData traceData = TraceFactory.getTraceData();
            if (traceData == null) {
                return this;
            }
            this.addTraceHeader(traceData);
            return this;
        }

        private void addTraceHeader(TraceData traceData) {
            this.putHeaderParamsMap("_inner_ecsb_trace_id", traceData.getTraceId() != null ? traceData.getTraceId() : TraceIdUtils.generate());
            this.putHeaderParamsMap("_inner_ecsb_rpc_id", traceData.getRpcId() != null ? traceData.getRpcId() : "0");
            this.bizId(traceData.getBizId());
        }

        public Builder restfulProtocolVersion(String restfulProtocolVersion) {
            this.restfulProtocolVersion = restfulProtocolVersion;
            return this;
        }

        public Builder method(String method) {
            if (!("get".equalsIgnoreCase(method) || "post".equalsIgnoreCase(method) || "cget".equalsIgnoreCase(method) || "cpost".equalsIgnoreCase(method))) {
                throw new IllegalArgumentException("\u53ea\u652f\u6301 'GET', 'CGET' or 'POST', 'CPOST' method\u7c7b\u578b");
            }
            this.method = method;
            return this;
        }

        public Builder timestamp(boolean timestampFlag) {
            this.timestamp = timestampFlag;
            return this;
        }

        public Builder nonce(boolean nonceFlag) {
            this.nonce = nonceFlag;
            return this;
        }

        public Builder requestURL(String url) {
            this.requestUrl = url;
            return this;
        }

        public Builder clearParamsMap() {
            this.paramsMap.clear();
            return this;
        }

        public Builder putParamsMap(String key, List<String> valueList) {
            if (valueList == null) {
                throw new IllegalArgumentException("valueList is not allow null.");
            }
            if (valueList instanceof ArrayList) {
                this.paramsMap.put(key, valueList);
            } else {
                this.paramsMap.put(key, Arrays.asList(valueList.toArray(new String[valueList.size()])));
            }
            return this;
        }

        public Builder putParamsMap(String key, String ... value) {
            if (value == null) {
                throw new IllegalArgumentException("value is not allow null.");
            }
            this.paramsMap.put(key, Arrays.asList(value));
            return this;
        }

        public Builder putParamsMapAll(Map<String, String> map) {
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.paramsMap.put(entry.getKey(), Arrays.asList(entry.getValue()));
                }
            } else {
                throw new IllegalArgumentException("empty map!!");
            }
            return this;
        }

        public Builder putParamsMap(Map<String, List<String>> map) {
            if (map == null) {
                throw new IllegalArgumentException("empty map!!");
            }
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                this.paramsMap.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder putParamsMapListAll(Map<String, List<String>> map) {
            if (map == null) {
                throw new IllegalArgumentException("empty map!!");
            }
            this.paramsMap.putAll(map);
            return this;
        }

        public Builder clearHeaderParamsMap() {
            this.headerParamsMap.clear();
            return this;
        }

        public Builder putHeaderParamsMap(String key, String value) {
            this.headerParamsMap.put(key, value);
            return this;
        }

        public Builder putHeaderParamsMapAll(Map<String, String> map) {
            if (map == null) {
                throw new IllegalArgumentException("empty map!!");
            }
            this.headerParamsMap.putAll(map);
            return this;
        }

        public Builder contentType(String contentTypeStr) {
            this.contentType = ContentType.parse(contentTypeStr);
            return this;
        }

        public Builder contentBody(ContentBody cb) {
            if (!this.method.equalsIgnoreCase("POST")) {
                throw new IllegalArgumentException("\u53d1\u9001contentBody\u5fc5\u987b\u4f7f\u7528POST");
            }
            if (this.attatchFileMap != null && !this.attatchFileMap.isEmpty()) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u540c\u65f6\u53d1\u9001 contentBody \u548c \u6587\u4ef6");
            }
            this.contentBody = cb;
            return this;
        }

        public Builder sginContentBody(boolean sign) {
            this.signContentBody = sign;
            return this;
        }

        public Builder signImpl(String signImpl) {
            this.signImpl = signImpl;
            return this;
        }

        public Builder verifySignImpl(String verifySignImpl) {
            this.verifySignImpl = verifySignImpl;
            return this;
        }

        public Builder diagnostic(boolean diagnostic) {
            this.diagnostic = diagnostic;
            return this;
        }

        public HttpParameters build() {
            HttpParameters httpParameters = new HttpParameters(this);
            if (this.attatchFileMap != null) {
                for (AttachFile attachFile : this.attatchFileMap.values()) {
                    attachFile.setHttpParameters(httpParameters);
                }
            }
            return httpParameters;
        }

        public String getTraceId() {
            return this.headerParamsMap.get("_inner_ecsb_trace_id");
        }

        public String getRpcId() {
            return this.headerParamsMap.get("_inner_ecsb_rpc_id");
        }

        public String getBizId() {
            return this.headerParamsMap.get(HttpCaller.bizIdKey());
        }

        public String getRequestId() {
            return this.headerParamsMap.get("_inner_ecsb_request_id");
        }

        public String getSignAlgorithm() {
            return this.headerParamsMap.get("_api_sign_algorithm");
        }

        public String api() {
            return this.api;
        }

        public String version() {
            return this.version;
        }

        public String accessKey() {
            return this.ak;
        }

        public String secretKey() {
            return this.sk;
        }

        public String method() {
            return this.method;
        }

        public String url() {
            return this.requestUrl;
        }

        public Map<String, List<String>> paramsMap() {
            return this.paramsMap;
        }

        public Map<String, String> headerMap() {
            return this.headerParamsMap;
        }

        public ContentBody contentBody() {
            return this.contentBody;
        }

        public ContentType contentType() {
            return this.contentType;
        }

        public ContentEncoding contentEncoding() {
            return this.contentEncoding;
        }
    }

    public static class AttachFile {
        private HttpParameters httpParameters;
        private String fileName;
        private byte[] fileBytes;
        private ContentEncoding contentEncoding;

        public AttachFile(String fileName, byte[] fileBytes, ContentEncoding contentEncoding) {
            this.fileName = fileName;
            this.fileBytes = fileBytes;
            this.contentEncoding = contentEncoding;
        }

        public ContentEncoding getContentEncoding() {
            if (this.contentEncoding == null) {
                return this.httpParameters != null ? this.httpParameters.getContentEncoding() : null;
            }
            return this.contentEncoding;
        }

        public void setHttpParameters(HttpParameters httpParameters) {
            this.httpParameters = httpParameters;
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getFileBytes() {
            return this.fileBytes;
        }
    }
}

