/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk.internel;

import com.alibaba.csb.sdk.HttpCallerException;
import com.alibaba.csb.sdk.SdkLogger;
import com.alibaba.csb.sdk.internel.HttpClientFactory;
import com.alibaba.csb.sdk.internel.HttpClientHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClientConnManager {
    public static final Boolean SKIP_CONN_POOL;
    private static final int VALIDATE_PERIOD;
    private static final int CLEAN_PERIOD;
    private static final int MAX_CONNECTION_TIMEOUT = 2000;
    private static final int MAX_SOCKET_TIMEOUT = 90000;
    private static final int MAX_CR_TIMEOUT = 1000;
    private static final List<String> SUPPORTED_CONNECTION_PARAMS;
    public static CloseableHttpClient HTTP_CLIENT;
    private static PoolingHttpClientConnectionManager connMgr;

    public static RequestConfig.Builder createConnBuilder() {
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        String CONN_TIMEOUT = System.getProperty(SUPPORTED_CONNECTION_PARAMS.get(1));
        String SO_TIMEOUT = System.getProperty(SUPPORTED_CONNECTION_PARAMS.get(2));
        String CR_TIMEOUT = System.getProperty(SUPPORTED_CONNECTION_PARAMS.get(3));
        int iconnTimeout = 2000;
        if (CONN_TIMEOUT != null) {
            try {
                iconnTimeout = Integer.parseInt(CONN_TIMEOUT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        configBuilder.setConnectTimeout(iconnTimeout);
        int isoTimeout = 90000;
        if (SO_TIMEOUT != null) {
            try {
                isoTimeout = Integer.parseInt(SO_TIMEOUT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        configBuilder.setSocketTimeout(isoTimeout);
        int icrTimeout = 1000;
        if (CR_TIMEOUT != null) {
            try {
                icrTimeout = Integer.parseInt(CR_TIMEOUT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        configBuilder.setConnectionRequestTimeout(icrTimeout);
        configBuilder.setCookieSpec("ignoreCookies");
        return configBuilder;
    }

    public static RequestConfig.Builder createConnBuilder(Map<String, String> params) {
        RequestConfig.Builder connBuilder = HttpClientConnManager.createConnBuilder();
        for (Map.Entry<String, String> es : params.entrySet()) {
            if (!SUPPORTED_CONNECTION_PARAMS.contains(es.getKey())) {
                throw new IllegalArgumentException("error connection param:" + es.getKey());
            }
            if (connMgr != null && es.getKey().equals(SUPPORTED_CONNECTION_PARAMS.get(0))) {
                connMgr.setMaxTotal(Integer.parseInt(es.getValue()));
            } else if (es.getKey().equals(SUPPORTED_CONNECTION_PARAMS.get(1))) {
                connBuilder.setConnectTimeout(Integer.parseInt(es.getValue()));
            } else if (es.getKey().equals(SUPPORTED_CONNECTION_PARAMS.get(2))) {
                connBuilder.setSocketTimeout(Integer.parseInt(es.getValue()));
            } else if (es.getKey().equals(SUPPORTED_CONNECTION_PARAMS.get(3))) {
                connBuilder.setConnectionRequestTimeout(Integer.parseInt(es.getValue()));
            }
            HttpClientHelper.printDebugInfo(String.format("set %s as %s", es.getKey(), es.getValue()));
        }
        return connBuilder;
    }

    static {
        block5: {
            SKIP_CONN_POOL = Boolean.getBoolean("http.caller.skip.connection.pool");
            VALIDATE_PERIOD = Integer.getInteger("http.caller.connection.validate.span", 100);
            CLEAN_PERIOD = Integer.getInteger("http.caller.connection.clean.span", 5000);
            SUPPORTED_CONNECTION_PARAMS = Arrays.asList("http.caller.connection.max", "http.caller.connection.timeout", "http.caller.connection.so.timeout", "http.caller.connection.cr.timeout", "http.caller.connection.async");
            HTTP_CLIENT = null;
            connMgr = null;
            try {
                if (!SKIP_CONN_POOL.booleanValue()) {
                    connMgr = HttpClientFactory.createConnManager();
                    String maxConnStr = System.getProperty(SUPPORTED_CONNECTION_PARAMS.get(0));
                    connMgr.setMaxTotal(maxConnStr == null ? 200 : Integer.parseInt(maxConnStr));
                    connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
                    connMgr.setValidateAfterInactivity(VALIDATE_PERIOD);
                    HTTP_CLIENT = HttpClientFactory.createCloseableHttpClient(connMgr);
                    IdleConnectionMonitorThread clearThread = new IdleConnectionMonitorThread(connMgr);
                    clearThread.setDaemon(true);
                    clearThread.start();
                } else if (SdkLogger.isLoggable()) {
                    SdkLogger.print("[WARNING] skip using connection pool");
                }
            }
            catch (HttpCallerException e) {
                HTTP_CLIENT = null;
                System.out.println("[WARNING] failed to create a pooled http client with the error : " + e.getMessage());
                if (!SdkLogger.isLoggable()) break block5;
                e.printStackTrace(System.out);
            }
        }
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(CLEAN_PERIOD);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

