/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.trace;

import com.alibaba.csb.sdk.HttpCaller;
import com.alibaba.csb.trace.TraceContext;
import com.alibaba.csb.trace.TraceData;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TraceFilter
implements Filter {
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String traceId = httpRequest.getHeader("_inner_ecsb_trace_id");
        String rpcId = httpRequest.getHeader("_inner_ecsb_rpc_id");
        String bizId = httpRequest.getHeader(HttpCaller.bizIdKey());
        String requestId = httpRequest.getHeader("_inner_ecsb_request_id");
        TraceData traceData = new TraceData(TraceData.Strategy.Filter, traceId, rpcId);
        traceData.setBizId(bizId);
        traceData.setRequestId(requestId);
        TraceContext.startTrace(traceData);
        try {
            chain.doFilter(request, (ServletResponse)httpResponse);
        }
        finally {
            TraceContext.endTrace();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

