/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class HttpReturn {
    private String requestUrl;
    public int httpCode;
    public String responseHttpStatus;
    public String response;
    public byte[] responseBytes;
    @Deprecated
    public String responseHeaders;
    public Map<String, String> respHttpHeaderMap;
    public Map<String, String> diagnosticInfo = new HashMap<String, String>();
    public boolean diagnosticFlag;

    public HttpReturn() {
    }

    public HttpReturn(String requestUrl, Map<String, String> directParamsMap, Map<String, String> headerParamsMap) {
        this(requestUrl, directParamsMap, headerParamsMap, null);
    }

    public HttpReturn(String requestUrl, Map<String, String> directParamsMap, Map<String, String> headerParamsMap, String body) {
        this.requestUrl = requestUrl;
        this.respHttpHeaderMap = new HashMap<String, String>();
        this.respHttpHeaderMap.putAll(directParamsMap);
        this.respHttpHeaderMap.putAll(headerParamsMap);
        this.response = body;
    }

    public HttpReturn(String response) {
        this.response = response;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public Map<String, String> getHeaderMap() {
        return this.respHttpHeaderMap;
    }

    public String getBodyStr() {
        return this.response;
    }

    public String getResponseStr() {
        if (this.response != null) {
            return this.response;
        }
        if (this.responseBytes != null) {
            try {
                ContentType contentType;
                String contentTypeStr;
                String charset = "UTF-8";
                if (this.respHttpHeaderMap != null && (contentTypeStr = this.respHttpHeaderMap.get("Content-Type")) != null && !contentTypeStr.equals("") && (contentType = ContentType.parse(contentTypeStr)) != null && contentType.getCharset() != null) {
                    charset = contentType.getCharset().name();
                }
                return new String(this.responseBytes, charset);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }
}

