/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.trace;

import com.alibaba.csb.trace.TraceBinder;
import com.alibaba.csb.trace.TraceData;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public class TraceFactory {
    private static final String DEFAULT_TRACE_BINDER_CLASS = "com.alibaba.csb.trace.impl.DefaultTraceBinder";
    private static final String TRACE_BINDER_CLASS = "com.alibaba.csb.trace.impl.StaticTraceBinder";
    private static final String TRACE_BINDER_PATH = "com.alibaba.csb.trace.impl.StaticTraceBinder".replace('.', '/') + ".class";
    static final int UNINITIALIZED = 0;
    static final int INITIALIZED = 1;
    static volatile int INITIALIZATION_STATE = 0;
    static volatile Class<?> traceBinderClass = null;

    static Set<URL> findPossibleStaticTraceBinderPathSet() {
        LinkedHashSet<URL> binderPaths = new LinkedHashSet<URL>();
        try {
            ClassLoader classLoader = TraceFactory.class.getClassLoader();
            Enumeration<URL> paths = classLoader == null ? ClassLoader.getSystemResources(TRACE_BINDER_PATH) : classLoader.getResources(TRACE_BINDER_PATH);
            while (paths.hasMoreElements()) {
                URL path = paths.nextElement();
                binderPaths.add(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return binderPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static TraceData getTraceData() {
        if (INITIALIZATION_STATE == 0) {
            Class<TraceFactory> clazz = TraceFactory.class;
            // MONITORENTER : com.alibaba.csb.trace.TraceFactory.class
            if (INITIALIZATION_STATE == 0) {
                TraceFactory.performInitialization();
            }
            // MONITOREXIT : clazz
        }
        try {
            TraceBinder traceBinder = (TraceBinder)traceBinderClass.getMethod("getSingleton", new Class[0]).invoke(traceBinderClass, new Object[0]);
            return traceBinder.getTraceData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void performInitialization() {
        Set<URL> traceBinderPathSet = TraceFactory.findPossibleStaticTraceBinderPathSet();
        if (traceBinderPathSet.size() > 1) {
            throw new RuntimeException(String.format("csb trace error, traceBinderPath:%s", traceBinderPathSet));
        }
        String traceBinder = traceBinderPathSet.isEmpty() ? DEFAULT_TRACE_BINDER_CLASS : TRACE_BINDER_CLASS;
        try {
            traceBinderClass = Class.forName(traceBinder);
            traceBinderClass.getMethod("getSingleton", new Class[0]).invoke(traceBinderClass, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        INITIALIZATION_STATE = 1;
    }
}

