/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat.client;

import com.alibaba.csp.sentinel.log.CommandCenterLog;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpRequest;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponse;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponseParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;

public class SimpleHttpClient {
    public SimpleHttpResponse get(SimpleHttpRequest request) throws IOException {
        if (request == null) {
            return null;
        }
        return this.request(request.getSocketAddress(), RequestMethod.GET, request.getRequestPath(), request.getParams(), request.getCharset(), request.getSoTimeout());
    }

    public SimpleHttpResponse post(SimpleHttpRequest request) throws IOException {
        if (request == null) {
            return null;
        }
        return this.request(request.getSocketAddress(), RequestMethod.POST, request.getRequestPath(), request.getParams(), request.getCharset(), request.getSoTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleHttpResponse request(InetSocketAddress socketAddress, RequestMethod type, String requestPath, Map<String, String> paramsMap, Charset charset, int soTimeout) throws IOException {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setSoTimeout(soTimeout);
            socket.connect(socketAddress, soTimeout);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), charset));
            requestPath = this.getRequestPath(type, requestPath, paramsMap, charset);
            writer.write(this.getStatusLine(type, requestPath) + "\r\n");
            if (charset != null) {
                writer.write("Content-Type: application/x-www-form-urlencoded; charset=" + charset.name() + "\r\n");
            } else {
                writer.write("Content-Type: application/x-www-form-urlencoded\r\n");
            }
            writer.write("Host: " + socketAddress.getHostName() + "\r\n");
            if (type == RequestMethod.GET) {
                writer.write("Content-Length: 0\r\n");
                writer.write("\r\n");
            } else {
                String params = this.encodeRequestParams(paramsMap, charset);
                writer.write("Content-Length: " + params.getBytes(charset).length + "\r\n");
                writer.write("\r\n");
                writer.write(params);
            }
            writer.flush();
            SimpleHttpResponse response = new SimpleHttpResponseParser().parse(socket.getInputStream());
            socket.close();
            socket = null;
            SimpleHttpResponse simpleHttpResponse = response;
            return simpleHttpResponse;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception ex) {
                    CommandCenterLog.info((String)("Error when closing " + (Object)((Object)type) + " request to " + socketAddress + ": "), (Throwable)ex);
                }
            }
        }
    }

    private String getRequestPath(RequestMethod type, String requestPath, Map<String, String> paramsMap, Charset charset) {
        if (type == RequestMethod.GET) {
            if (requestPath.contains("?")) {
                return requestPath + "&" + this.encodeRequestParams(paramsMap, charset);
            }
            return requestPath + "?" + this.encodeRequestParams(paramsMap, charset);
        }
        return requestPath;
    }

    private String getStatusLine(RequestMethod type, String requestPath) {
        if (type == RequestMethod.POST) {
            return "POST " + requestPath + " HTTP/1.1";
        }
        return "GET " + requestPath + " HTTP/1.1";
    }

    private String encodeRequestParams(Map<String, String> paramsMap, Charset charset) {
        if (paramsMap == null || paramsMap.isEmpty()) {
            return "";
        }
        try {
            StringBuilder paramsBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                paramsBuilder.append(URLEncoder.encode(entry.getKey(), charset.name())).append("=").append(URLEncoder.encode(entry.getValue(), charset.name())).append("&");
            }
            if (paramsBuilder.length() > 0) {
                paramsBuilder.delete(paramsBuilder.length() - 1, paramsBuilder.length());
            }
            return paramsBuilder.toString();
        }
        catch (Throwable e) {
            RecordLog.info((String)"Encode request params fail", (Throwable)e);
            return "";
        }
    }

    private static enum RequestMethod {
        GET,
        POST;

    }
}

