/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.zuul.api;

import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.api.matcher.RequestContextApiMatcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ZuulGatewayApiMatcherManager {
    private static final Map<String, RequestContextApiMatcher> API_MATCHER_MAP = new ConcurrentHashMap<String, RequestContextApiMatcher>();

    public static Map<String, RequestContextApiMatcher> getApiMatcherMap() {
        return Collections.unmodifiableMap(API_MATCHER_MAP);
    }

    public static RequestContextApiMatcher getMatcher(String apiName) {
        if (apiName == null) {
            return null;
        }
        return API_MATCHER_MAP.get(apiName);
    }

    public static Set<ApiDefinition> getApiDefinitionSet() {
        HashSet<ApiDefinition> set = new HashSet<ApiDefinition>();
        for (RequestContextApiMatcher matcher : API_MATCHER_MAP.values()) {
            set.add(matcher.getApiDefinition());
        }
        return set;
    }

    static synchronized void loadApiDefinitions(Set<ApiDefinition> definitions) {
        if (definitions == null || definitions.isEmpty()) {
            API_MATCHER_MAP.clear();
            return;
        }
        for (ApiDefinition definition : definitions) {
            ZuulGatewayApiMatcherManager.addApiDefinition(definition);
        }
    }

    static void addApiDefinition(ApiDefinition definition) {
        API_MATCHER_MAP.put(definition.getApiName(), new RequestContextApiMatcher(definition));
    }

    private ZuulGatewayApiMatcherManager() {
    }
}

