/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.qwen_tts_realtime;

import com.alibaba.dashscope.audio.qwen_tts_realtime.QwenTtsRealtimeCallback;
import com.alibaba.dashscope.audio.qwen_tts_realtime.QwenTtsRealtimeConfig;
import com.alibaba.dashscope.audio.qwen_tts_realtime.QwenTtsRealtimeParam;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.DashScopeHeaders;
import com.alibaba.dashscope.protocol.okhttp.OkHttpClientFactory;
import com.alibaba.dashscope.utils.ApiKey;
import com.alibaba.dashscope.utils.Constants;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QwenTtsRealtime
extends WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(QwenTtsRealtime.class);
    private QwenTtsRealtimeParam parameters;
    private QwenTtsRealtimeCallback callback;
    private OkHttpClient client;
    private WebSocket websocktetClient;
    private AtomicBoolean isOpen = new AtomicBoolean(false);
    private AtomicReference<CountDownLatch> connectLatch = new AtomicReference<Object>(null);
    private String sessionId = null;
    private String lastResponseId = null;
    private long lastFirstTextTime = -1L;
    private long lastFirstAudioDelay = -1L;
    private AtomicBoolean isClosed = new AtomicBoolean(false);

    public QwenTtsRealtime(QwenTtsRealtimeParam param, QwenTtsRealtimeCallback callback) {
        this.parameters = param;
        this.callback = callback;
    }

    public void checkStatus() {
        if (this.isClosed.get()) {
            throw new RuntimeException("tts is already closed!");
        }
    }

    public void connect() throws NoApiKeyException, InterruptedException {
        this.checkStatus();
        Request request = this.buildConnectionRequest(ApiKey.getApiKey(this.parameters.getApikey()), false, this.parameters.getWorkspace(), this.parameters.getHeaders(), this.parameters.getUrl());
        this.client = OkHttpClientFactory.getOkHttpClient();
        this.websocktetClient = this.client.newWebSocket(request, (WebSocketListener)this);
        this.connectLatch.set(new CountDownLatch(1));
        this.connectLatch.get().await();
    }

    public void updateSession(QwenTtsRealtimeConfig config) {
        this.checkStatus();
        JsonObject configJson = config.getConfig();
        HashMap<String, String> update_request = new HashMap<String, String>();
        update_request.put("event_id", this.generateSessionId());
        update_request.put("type", "session.update");
        update_request.put("session", (String)configJson);
        this.sendMessage(JsonUtils.gson.toJson(update_request), true);
    }

    public void appendText(String text) {
        this.checkStatus();
        HashMap<String, String> append_request = new HashMap<String, String>();
        append_request.put("event_id", this.generateSessionId());
        append_request.put("type", "input_text_buffer.append");
        append_request.put("text", text);
        this.sendMessage(JsonUtils.gson.toJson(append_request), true);
        if (this.lastFirstTextTime < 0L) {
            this.lastFirstTextTime = System.currentTimeMillis();
        }
    }

    public void commit() {
        this.checkStatus();
        HashMap<String, String> commit_request = new HashMap<String, String>();
        commit_request.put("event_id", this.generateSessionId());
        commit_request.put("type", "input_text_buffer.commit");
        this.sendMessage(JsonUtils.gson.toJson(commit_request), true);
    }

    public void clearAppendedText() {
        this.checkStatus();
        HashMap<String, String> clear_request = new HashMap<String, String>();
        clear_request.put("event_id", this.generateSessionId());
        clear_request.put("type", "input_text_buffer.clear");
        this.sendMessage(JsonUtils.gson.toJson(clear_request), true);
    }

    public void cancelResponse() {
        this.checkStatus();
        HashMap<String, String> cancel_request = new HashMap<String, String>();
        cancel_request.put("event_id", this.generateSessionId());
        cancel_request.put("type", "response.cancel");
        this.sendMessage(JsonUtils.gson.toJson(cancel_request), true);
    }

    public void finish() {
        this.checkStatus();
        HashMap<String, String> cancel_request = new HashMap<String, String>();
        cancel_request.put("event_id", this.generateSessionId());
        cancel_request.put("type", "session.finish");
        this.sendMessage(JsonUtils.gson.toJson(cancel_request), true);
    }

    public void close() {
        this.checkStatus();
        this.websocktetClient.close(1000, "bye");
        this.isClosed.set(true);
    }

    public void close(int code, String reason) {
        this.checkStatus();
        this.websocktetClient.close(code, reason);
        this.isClosed.set(true);
    }

    public void sendRaw(String rawData) {
        this.checkStatus();
        this.sendMessage(rawData, true);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getResponseId() {
        return this.lastResponseId;
    }

    public long getFirstAudioDelay() {
        return this.lastFirstAudioDelay;
    }

    private Request buildConnectionRequest(String apiKey, boolean isSecurityCheck, String workspace, Map<String, String> customHeaders, String baseWebSocketUrl) throws NoApiKeyException {
        Request.Builder bd = new Request.Builder();
        bd.headers(Headers.of(DashScopeHeaders.buildWebSocketHeaders(apiKey, isSecurityCheck, workspace, customHeaders)));
        String url = Constants.baseWebsocketApiUrl;
        if (baseWebSocketUrl != null) {
            url = baseWebSocketUrl;
        }
        Request request = bd.url(url).build();
        return request;
    }

    private String generateSessionId() {
        return "event_" + UUID.randomUUID().toString().replace("-", "");
    }

    private void sendMessage(String message, boolean enableLog) {
        if (enableLog) {
            log.debug("send message: " + message);
        }
        Boolean isOk = this.websocktetClient.send(message);
    }

    private void sendMessage(ByteString message) {
        this.websocktetClient.send(message);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.isOpen.set(true);
        this.connectLatch.get().countDown();
        log.debug("WebSocket opened");
        this.callback.onOpen();
    }

    public void onMessage(WebSocket webSocket, String text) {
        if (text.length() > 1024) {
            log.debug("Received message: " + text.substring(0, 1024));
        } else {
            log.debug("Received message: " + text);
        }
        JsonObject response = JsonUtils.parse(text);
        this.callback.onEvent(response);
        if (response.has("type")) {
            String type;
            switch (type = response.get("type").getAsString()) {
                case "session.created": {
                    this.sessionId = response.get("session").getAsJsonObject().get("id").getAsString();
                    break;
                }
                case "response.created": {
                    this.lastResponseId = response.get("response").getAsJsonObject().get("id").getAsString();
                    break;
                }
                case "response.audio.delta": {
                    if (this.lastFirstTextTime <= 0L || this.lastFirstAudioDelay >= 0L) break;
                    this.lastFirstAudioDelay = System.currentTimeMillis() - this.lastFirstTextTime;
                    break;
                }
                case "response.done": {
                    log.debug("[Metric] response: " + this.lastResponseId + ", first audio delay: " + this.lastFirstAudioDelay + " ms");
                }
            }
        }
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.isOpen.set(false);
        this.connectLatch.get().countDown();
        log.debug("WebSocket closed");
        this.callback.onClose(code, reason);
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        this.isClosed.set(true);
        this.websocktetClient.close(code, reason);
        log.debug("WebSocket closing: " + code + ", " + reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        log.error("WebSocket failed: " + t.getMessage());
    }
}

