/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.app;

import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.app.ApplicationParam;
import com.alibaba.dashscope.app.ApplicationResult;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.StreamingMode;
import io.reactivex.Flowable;

public class Application {
    private final SynchronizeHalfDuplexApi<ApplicationParam> syncApi;
    private final ApiServiceOption serviceOption = this.defaultServiceOption();

    private ApiServiceOption defaultServiceOption() {
        return ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().httpMethod(HttpMethod.POST)).outputMode(OutputMode.ACCUMULATE)).build();
    }

    public Application() {
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public Application(String baseUrl) {
        this.serviceOption.setBaseHttpUrl(baseUrl);
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public ApplicationResult call(ApplicationParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.setRequestOption(this.serviceOption, param.getAppId());
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        return ApplicationResult.fromDashScopeResult(this.syncApi.call(param));
    }

    public Flowable<ApplicationResult> streamCall(ApplicationParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.setRequestOption(this.serviceOption, param.getAppId());
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        return this.syncApi.streamCall(param).map(ApplicationResult::fromDashScopeResult);
    }

    private void setRequestOption(ApiServiceOption serviceOption, String resourceId) {
        if (serviceOption == null) {
            return;
        }
        serviceOption.setIsService(false);
        serviceOption.setTaskGroup("apps");
        serviceOption.setTask(resourceId);
        serviceOption.setFunction("completion");
    }
}

