/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common.serialize.support.java;

import com.alibaba.dubbo.common.serialize.ObjectInput;
import com.alibaba.dubbo.common.serialize.support.java.CompactedObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaObjectInput
implements ObjectInput {
    public static final int MAX_BYTE_ARRAY_LENGTH = 0x800000;
    private final ObjectInputStream mIn;

    public JavaObjectInput(InputStream is) throws IOException {
        this.mIn = new ObjectInputStream(is);
    }

    public JavaObjectInput(InputStream is, boolean compacted) throws IOException {
        this.mIn = compacted ? new CompactedObjectInputStream(is) : new ObjectInputStream(is);
    }

    @Override
    public boolean readBool() throws IOException {
        return this.mIn.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.mIn.readByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.mIn.readShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.mIn.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.mIn.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.mIn.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.mIn.readDouble();
    }

    @Override
    public byte[] readBytes() throws IOException {
        int len = this.mIn.readInt();
        if (len < 0) {
            return null;
        }
        if (len == 0) {
            return new byte[0];
        }
        if (len > 0x800000) {
            throw new IOException("Byte array length too large. " + len);
        }
        byte[] b = new byte[len];
        this.mIn.readFully(b);
        return b;
    }

    @Override
    public String readUTF() throws IOException {
        int len = this.mIn.readInt();
        if (len < 0) {
            return null;
        }
        return this.mIn.readUTF();
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        byte b = this.mIn.readByte();
        if (b == 0) {
            return null;
        }
        return this.mIn.readObject();
    }

    @Override
    public <T> T readObject(Class<T> cls) throws IOException, ClassNotFoundException {
        return (T)this.readObject();
    }

    @Override
    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        return (T)this.readObject();
    }
}

