/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common.serialize.support.java;

import com.alibaba.dubbo.common.serialize.ObjectOutput;
import com.alibaba.dubbo.common.serialize.support.java.CompactedObjectOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class JavaObjectOutput
implements ObjectOutput {
    private final ObjectOutputStream mOut;

    public JavaObjectOutput(OutputStream os) throws IOException {
        this.mOut = new ObjectOutputStream(os);
    }

    public JavaObjectOutput(OutputStream os, boolean compact) throws IOException {
        this.mOut = compact ? new CompactedObjectOutputStream(os) : new ObjectOutputStream(os);
    }

    public void writeBool(boolean v) throws IOException {
        this.mOut.writeBoolean(v);
    }

    public void writeByte(byte v) throws IOException {
        this.mOut.writeByte(v);
    }

    public void writeShort(short v) throws IOException {
        this.mOut.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        this.mOut.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.mOut.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.mOut.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.mOut.writeDouble(v);
    }

    public void writeBytes(byte[] b) throws IOException {
        if (b == null) {
            this.mOut.writeInt(-1);
        } else {
            this.writeBytes(b, 0, b.length);
        }
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.mOut.writeInt(len);
        this.mOut.write(b, off, len);
    }

    public void writeUTF(String v) throws IOException {
        if (v == null) {
            this.mOut.writeInt(-1);
        } else {
            this.mOut.writeInt(v.length());
            this.mOut.writeUTF(v);
        }
    }

    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.mOut.writeByte(0);
        } else {
            this.mOut.writeByte(1);
            this.mOut.writeObject(obj);
        }
    }

    public void flushBuffer() throws IOException {
        this.mOut.flush();
    }
}

