/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.serialize.Serialization;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.Codec;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import java.io.IOException;

public abstract class AbstractCodec
implements Codec {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Serialization getSerialization(Channel channel) {
        return CodecSupport.getSerialization(channel.getUrl());
    }

    protected void checkPayload(Channel channel, long size) throws IOException {
        int payload = 0x800000;
        if (channel != null && channel.getUrl() != null) {
            payload = channel.getUrl().getPositiveParameter("payload", 0x800000);
        }
        if (size > (long)payload) {
            IOException e = new IOException("Data length too large: " + size + ", max payload: " + payload + ", channel: " + channel);
            this.logger.error(e);
            throw e;
        }
    }
}

