/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.netty;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.io.Bytes;
import com.alibaba.dubbo.common.io.UnsafeByteArrayInputStream;
import com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.Codec;
import com.alibaba.dubbo.remoting.transport.netty.NettyChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

final class NettyCodecAdapter {
    private final org.jboss.netty.channel.ChannelHandler encoder = new InternalEncoder();
    private final org.jboss.netty.channel.ChannelHandler decoder = new InternalDecoder();
    private final Codec codec;
    private final URL url;
    private final int bufferSize;
    private final ChannelHandler handler;

    public NettyCodecAdapter(Codec codec, URL url, ChannelHandler handler) {
        this.codec = codec;
        this.url = url;
        this.handler = handler;
        int b = url.getPositiveParameter("buffer", 8192);
        this.bufferSize = b >= 1024 && b <= 16384 ? b : 8192;
    }

    public org.jboss.netty.channel.ChannelHandler getEncoder() {
        return this.encoder;
    }

    public org.jboss.netty.channel.ChannelHandler getDecoder() {
        return this.decoder;
    }

    private class InternalDecoder
    extends SimpleChannelUpstreamHandler {
        private int mOffset = 0;
        private int mLimit = 0;
        private byte[] mBuffer = null;

        private InternalDecoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
            block19: {
                block18: {
                    int off;
                    int limit;
                    Object o = event.getMessage();
                    if (!(o instanceof ChannelBuffer)) {
                        ctx.sendUpstream((ChannelEvent)event);
                        return;
                    }
                    ChannelBuffer input = (ChannelBuffer)o;
                    int readable = input.readableBytes();
                    if (readable <= 0) {
                        return;
                    }
                    byte[] buf = this.mBuffer;
                    if (buf == null) {
                        buf = new byte[NettyCodecAdapter.this.bufferSize];
                        limit = 0;
                        off = 0;
                    } else {
                        off = this.mOffset;
                        limit = this.mLimit;
                    }
                    NettyChannel channel = NettyChannel.getOrAddChannel(ctx.getChannel(), NettyCodecAdapter.this.url, NettyCodecAdapter.this.handler);
                    boolean remaining = true;
                    try {
                        block4: do {
                            int read = Math.min(readable, buf.length - limit);
                            input.readBytes(buf, limit, read);
                            readable -= read;
                            UnsafeByteArrayInputStream bis = new UnsafeByteArrayInputStream(buf, off, (limit += read) - off);
                            do {
                                Object msg;
                                try {
                                    msg = NettyCodecAdapter.this.codec.decode(channel, bis);
                                }
                                catch (IOException e) {
                                    remaining = false;
                                    throw e;
                                }
                                if (msg == Codec.NEED_MORE_INPUT) {
                                    if (off == 0) {
                                        if (readable <= 0) continue block4;
                                        buf = Bytes.copyOf(buf, buf.length << 1);
                                        continue block4;
                                    }
                                    int len = limit - off;
                                    System.arraycopy(buf, off, buf, 0, len);
                                    off = 0;
                                    limit = len;
                                    continue block4;
                                }
                                int pos = bis.position();
                                if (off == pos) {
                                    remaining = false;
                                    throw new IOException("Decode without read data.");
                                }
                                if (msg != null) {
                                    Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)msg, (SocketAddress)event.getRemoteAddress());
                                }
                                off = pos;
                            } while (bis.available() > 0);
                        } while (readable > 0);
                        Object var16_16 = null;
                        if (!remaining) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        if (remaining) {
                            int len = limit - off;
                            if (len < buf.length / 2) {
                                System.arraycopy(buf, off, buf, 0, len);
                                off = 0;
                                limit = len;
                            }
                            this.mBuffer = buf;
                            this.mOffset = off;
                            this.mLimit = limit;
                        } else {
                            this.mBuffer = null;
                            this.mLimit = 0;
                            this.mOffset = 0;
                        }
                        NettyChannel.removeChannelIfDisconnected(ctx.getChannel());
                        throw throwable;
                    }
                    int len = limit - off;
                    if (len < buf.length / 2) {
                        System.arraycopy(buf, off, buf, 0, len);
                        off = 0;
                        limit = len;
                    }
                    this.mBuffer = buf;
                    this.mOffset = off;
                    this.mLimit = limit;
                    break block19;
                }
                this.mBuffer = null;
                this.mLimit = 0;
                this.mOffset = 0;
            }
            NettyChannel.removeChannelIfDisconnected(ctx.getChannel());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    @ChannelHandler.Sharable
    private class InternalEncoder
    extends OneToOneEncoder {
        private InternalEncoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object encode(ChannelHandlerContext ctx, Channel ch, Object msg) throws Exception {
            UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream(1024);
            NettyChannel channel = NettyChannel.getOrAddChannel(ch, NettyCodecAdapter.this.url, NettyCodecAdapter.this.handler);
            try {
                NettyCodecAdapter.this.codec.encode(channel, os, msg);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                NettyChannel.removeChannelIfDisconnected(ch);
                throw throwable;
            }
            NettyChannel.removeChannelIfDisconnected(ch);
            return ChannelBuffers.wrappedBuffer((ByteBuffer)os.toByteBuffer());
        }
    }
}

