/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tbremoting.invoke;

import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.exception.HSFTimeOutException;
import com.taobao.middleware.logger.support.LoggerHelper;
import com.taobao.remoting.ResponseFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HSFFuture {
    private final Future<Object> future;

    public HSFFuture(Future<Object> future) {
        this.future = future;
    }

    public Object getResponse(long timeout) throws HSFException, InterruptedException, Throwable {
        try {
            Object rawResponse = this.future.get(timeout, TimeUnit.MILLISECONDS);
            if (ResponseFuture.ASYN_NOT_DONE == rawResponse) {
                throw new HSFException("Designated timeout[" + timeout + "ms]time has arrived, but the result has not returned");
            }
            HSFResponse hsfResp = (HSFResponse)rawResponse;
            if (hsfResp.isError()) {
                throw new HSFException(hsfResp.getErrorMsg(), hsfResp.getErrorMsg());
            }
            Object appResponse = hsfResp.getAppResponse();
            if (appResponse instanceof Throwable) {
                throw (Throwable)appResponse;
            }
            return appResponse;
        }
        catch (ExecutionException e) {
            throw new HSFTimeOutException(this.getErrorLog(), (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new HSFTimeOutException(this.getErrorLog(), (Throwable)e);
        }
    }

    private String getErrorLog() {
        return LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0002", (String)"Business problems", (String)"");
    }
}

