package com.edas.ext.web;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

/**
 * 
 * 防止默认的健康检查 URL 被屏蔽。
 * the default url is:http://ip:port/_ehc.html
 * @author toava
 *
 */
public class DefaultHealthCheckUrlFilter implements Filter {

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {

	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		if(request instanceof HttpServletRequest){
			HttpServletRequest httpRequest = (HttpServletRequest)request;
			
			String contextPath = httpRequest.getRequestURI();
			if(contextPath.endsWith("_ehc.html")){
				response.getWriter().println("200");
				//直接拦截，后面的逻辑就不执行了
				return ;
			}
		}
		
		chain.doFilter(request, response);
	}

	@Override
	public void destroy() {

	}

}
