package com.edas.ext.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import com.alibaba.edas.sdk.util.EdasConstant;

public class EdasCommonFilterInitializer implements ServletContainerInitializer {
	private final Logger logger = Logger.getLogger("edas-common-filter");
	@Override
	public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
		Properties properties = loadEdasCommonFilter();

		for(Entry<Object,Object> entry : properties.entrySet()){
			String filterClass = (String) entry.getValue();
			String filterName = (String)entry.getKey();
			if(filterClass == null || filterClass.trim().length() == 0){
				continue ;
			}
			
			try {
				Class<?> clazz = Class.forName(filterClass);
				if(!Filter.class.isAssignableFrom(clazz)){
					String logInfo = String.format("the calss for [%s] is not assignable from javax.servlet.Filter", clazz.getName());
					logger.warning(logInfo);
					continue ;
				}
				
				logger.info("filter="+filterName+"; filter class="+filterClass);
				FilterRegistration.Dynamic filterDynamic = ctx.addFilter(filterName, filterClass);
				filterDynamic.addMappingForUrlPatterns(null, true, "/*");
			} catch (ClassNotFoundException e) {
				logger.log(Level.SEVERE,e.getMessage());
			}
		}
	}
	
	private final static Properties loadEdasCommonFilter(){
		Properties properties = new Properties();
		InputStream resource = null ;
		try {
			resource = EdasCommonFilterInitializer.class.getClassLoader().getResourceAsStream(EdasConstant.EDAS_COMMON_FILTER);
			properties.load(resource);
		}catch(Exception e){
			// quietly
		} finally {
			if(resource != null){
				try {
					resource.close();
				} catch (IOException e) {
					// quietly
				}
			}
		}
		return properties;
	}
}
