/**
 * 
 */
package com.taobao.csp.sentinel;

import com.taobao.csp.sentinel.node.Node;
import com.taobao.csp.sentinel.slotchain.ResourceWraper;

/**
 * @author qinan.qn(qinan.qn@taobao.com) 2014��5��19��
 */
public abstract class Entry {

    private long             createTime;
    private Node             curNode;
    private Node             originNode;
    private Throwable        error;
    protected ResourceWraper resourceWraper;

    public Entry(ResourceWraper resourceWraper){
        this.resourceWraper = resourceWraper;
        this.createTime = TimeUtil.currentTimeMillis();
    }

    public ResourceWraper getResourceWraper() {
        return resourceWraper;
    }

    public abstract void exit();

    abstract Entry _exit();

    public abstract void exit(Object... args);

    abstract Entry _exit(Object... args);

    public abstract Node getLastNode();

    public long getCreateTime() {
        return createTime;
    }

    public Node getCurNode() {
        return curNode;
    }

    public void setCurNode(Node node) {
        this.curNode = node;
    }

    public Throwable getError() {
        return error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public Node getOriginNode() {
        return originNode;
    }

    public void setOriginNode(Node originNode) {
        this.originNode = originNode;
    }

}
