/**
 * 
 */
package com.taobao.csp.sentinel;

import java.lang.reflect.Method;

import com.taobao.csp.courier.RecordLog;
import com.taobao.csp.sentinel.context.ContextUtil;
import com.taobao.csp.sentinel.slotchain.ResourceWraper;
import com.taobao.csp.sentinel.slots.block.BlockException;

/**
 * @author qinan.qn@taobao.com 2014��5��30��
 * @author youji.zj@taobao.com
 * @author jialiang.linjl(jialiang.linjl@taobao.com
 */
public class SphO {
  
    public static boolean entry(Method m, NodeType type, Object... args) {
        try {
            Env.sph.entry(m, type, args);
        } catch (BlockException e) {
            return false;
        } catch (Throwable e) {
            RecordLog.info("[sentinel] fatal error", e);
            return true;
        }
        return true;
    }


    
    public static boolean entry(Method m) {
        return entry(m, NodeType.CUSTOM, new Object[0]);
    }

    public static boolean entry(Method m, Object... args) {
        return entry(m, NodeType.CUSTOM,  args);
    }

    public static boolean entry(String s, NodeType type, Object... args) {
        try {
            Env.sph.entry(s, type, args);
        } catch (BlockException e) {
            return false;
        } catch (Throwable e) {
            RecordLog.info("[sentinel] fatal error", e);
            return true;
        }
        return true;
    }



    public static boolean entry(String s) {
        return entry(s, NodeType.CUSTOM,  new Object[0]);
    }

    public static boolean entry(String s, NodeType nodeType) {
        return entry(s, nodeType,  new Object[0]);
    }

    public static boolean entry(String s, Object... args) {
        return entry(s, NodeType.CUSTOM,  args);
    }

    public static boolean entry(ResourceWraper resourceWraper, Object... args) {
        try {
            Env.sph.entry(resourceWraper, args);
        } catch (BlockException e) {
            return false;
        } catch (Throwable e) {
            RecordLog.info("[sentinel] fatal error", e);
            return true;
        }
        return true;
    }

    public static boolean entry(ResourceWraper resourceWraper) {

        return entry(resourceWraper, new Object[0]);
    }

    public static void exit(Object... args) {
        ContextUtil.getContext().getCurEntry().exit(args);
    }

    public static void exit() {
        ContextUtil.getContext().getCurEntry().exit(new Object[0]);
    }
}
