package com.taobao.csp.sentinel.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

import javax.servlet.http.HttpServletRequest;

import com.taobao.csp.sentinel.context.Context;
import com.taobao.csp.sentinel.context.ContextUtil;
import com.taobao.csp.sentinel.node.ClusterNode;
import com.taobao.csp.sentinel.node.DefaultNode;
import com.taobao.csp.sentinel.slots.block.BlockException;
import com.taobao.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.taobao.csp.sentinel.slots.block.callbacks.CallbackManager;
import com.taobao.csp.sentinel.slots.block.callbacks.HsfProviderBlock;
import com.taobao.csp.sentinel.slots.block.callbacks.UrlBlock;
import com.taobao.csp.sentinel.slots.block.callbacks.UrlClean;
import com.taobao.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.taobao.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.taobao.csp.sentinel.slots.block.flow.ParamFlowRuleManager;

/***
 * sentinel �����ṩ�Ĺ�����
 * 
 * @author youji.zj youji.zj@taobao.com
 * @since 2014-7-3
 * @author jialiang.linjl(jialiang.linjl@taobao.com
 * @since 2016-01-07
 */
public class SentinelUtil {
    
    private static final String[] IP_HEADERS = {
                                                "X-Forwarded-For",
                                                "Proxy-Client-IP",
                                                "WL-Proxy-Client-IP", // ���Ȼ�ȡ�����������õ���ʵ�û�ip
                                                "X-Real-IP",          // Tengine ���� remoteIP�����û���õ� NS-Client-IP����ô�������ʵ���û� ip
                                                "NS-Client-IP",       // �Ա� NAT ��ʽ���õ�ip
                                            };

    public static final String BLOCL_EXCELTION_FLAG = "SentinelBlockException";

    public static String       ip                   = "";
    static {
        try {
            InetAddress hostInfo = InetAddress.getLocalHost();
            ip = hostInfo.getHostAddress();
        } catch (UnknownHostException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

    public static boolean isBlockException(Throwable t) {
        if (null == t) {
            return false;
        }

        int counter = 0;
        Throwable cause = t;
        while (cause != null && counter++ < 50) {
            if ((cause instanceof BlockException) || (BLOCL_EXCELTION_FLAG.equals(cause.getMessage()))) {
                return true;
            }
            cause = cause.getCause();
        }

        return false;
    }

    public static void clearStactTrace(Throwable t) {
        t.setStackTrace(BlockException.sentinelStackTrace);
    }

    public static boolean hasAuthorityConfig(String resource) {
        return AuthorityRuleManager.hasConfig(resource);
    }

    public static boolean hasFlowConfig(String resource) {
        return FlowRuleManager.hasConfig(resource);
    }

    public static boolean hasParamflowConfig(String resource) {
        return ParamFlowRuleManager.hasConfig(resource);
    }

    public static boolean hasDegradeConfig(String resource) {
        return DegradeRuleManager.hasConfig(resource);
    }

    public static void registerUrlClean(UrlClean urlClean) {
        if (urlClean == null) {
            return;
        }
        CallbackManager.setUrlClean(urlClean);
    }

    public static void registerUrlBlock(UrlBlock urlBlock) {
        if (urlBlock == null) {
            return;
        }
        CallbackManager.setUrlBlock(urlBlock);
    }

    public static void registerHsfProviderBlock(HsfProviderBlock hsfProviderBlock) {
        if (hsfProviderBlock == null) {
            return;
        }
        CallbackManager.setHsfProviderBlock(hsfProviderBlock);
    }

    /**
     * ��ȡԶ�̿ͻ��˵� IP
     * @param request
     * @return
     */
    public static final String getRemoteAddress(HttpServletRequest request) {
        String ip = null;
        boolean valid = false;
        for (String header : IP_HEADERS) {
            ip = request.getHeader(header);
            valid = checkIP(ip);
            if (valid) {
                break;
            }
        }
        if (!valid) {
            ip = request.getRemoteAddr();
        }
        // ����ʱ���ж��ŷָ��� ip����ȡ��һ������
        int index = ip.indexOf(',');
        if (index != -1) {
            String firstIp = ip.substring(0, index).trim();
            if (checkIP(ip)) {
                ip = firstIp;
            }
        }
        return ip;
    }

    private static final boolean checkIP(String ip) {
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            return false;
        } else {
            return true;
        }
    }
    
    public static void trace(Throwable e){
        if(e instanceof BlockException){
            return;
        }
        
        Context context = ContextUtil.getContext();
        if (context == null) {
            return;
        }
        
        DefaultNode cuNode = (DefaultNode)context.getCurNode();
        if (cuNode == null) {
            return;
        }
        
        // Constants.ON ΪfalseʱclusNode��Ϊ��
        ClusterNode clusNode = cuNode.getClusterNode();
        if (clusNode == null) {
            return;
        }
        
        String customKey = ExceptionUtil.filterUnderlyingThrowable(e).getClass().getName();      
        clusNode.trace(customKey);
        ExceptionLogUtil.log(customKey);
    }
}
