package com.taobao.eagleeye;

/**
 * 用于监听 EagleEye 调用上下文的变化的回调
 * @since 1.5.0-exported
 */
public abstract class EagleEyeContextListener {

	/**
	 * 优先级，将会影响 Listener 之间的执行顺序，优先级数字越小越先被执行
	 */
	protected int priority = 100;

	/**
	 * Listener 的源码信息
	 */
	private String source;

	/**
	 * 获取 Listener 的优先级，优先级数字越小的 Listener 越先被执行
	 */
	public int getPriority() {
		return priority;
	}

	/**
	 * 获取 Listener 的源码信息
	 */
	public final String getSource() {
		return source;
	}

	/**
	 * 设置 Listener 的源码信息
	 * @param source
	 */
	public final void setSource(String source) {
		this.source = source;
	}

	/**
	 * 在{@link EagleEye#setRpcContext(RpcContext_inner)} 前执行的回调。
	 * 当前 context 可以通过 {@link EagleEye#getRpcContext()} 取得
	 * @param context 将要被设置的 context
	 */
	public void beforeSet(RpcContext_inner context) {
		// noop
	}

	/**
	 * 在{@link EagleEye#setRpcContext(RpcContext_inner)} 后执行的回调
	 * @param context 当前已被设置的 context
	 */
	public void afterSet(RpcContext_inner context) {
		// noop
	}

	/**
	 * 在 {@link RpcContext_inner#startTrace(String)} 后执行的回调
	 * @param context
	 */
	public void afterStartTrace(RpcContext_inner context) {
		// noop
	}

	/**
	 * 在 {@link RpcContext_inner#endTrace(String, int)} 后执行的回调
	 * @param context
	 */
	public void afterEndTrace(RpcContext_inner context) {
		// noop
	}

	/**
	 * 在 {@link RpcContext_inner#startRpc(String, String)} 后执行的回调
	 * @param context
	 */
	public void afterStartRpc(RpcContext_inner context) {
		// noop
	}

	/**
	 * 在 {@link RpcContext_inner#endRpc(String, int, String)} 后执行的回调
	 * @param context
	 */
	public void afterEndRpc(RpcContext_inner context) {
		// noop
	}

	/**
	 * 在 {@link RpcContext_inner#rpcClientSend()} 后执行的回调
	 * @param context
	 */
	public void afterRpcClientSend(RpcContext_inner context) {
		// noop
	}

	/**
	 * 在 {@link RpcContext_inner#rpcServerRecv(String, String)} 后执行的回调
	 * @param context
	 */
	public void afterRpcServerRecv(RpcContext_inner context) {
		// noop
	}

	/**
	 * 在 {@link RpcContext_inner#rpcServerSend(int, String, String)} 后执行的回调
	 * @param context
	 */
	public void afterRpcServerSend(RpcContext_inner context) {
		// noop
	}

	/**
	 * 在 {@link RpcContext_inner#startLocal(String, String)} 后执行的回调
	 * @param context
	 * @param localContext
	 */
	public void afterStartLocal(RpcContext_inner context, LocalContext_inner localContext) {
		// noop
	}

	/**
	 * 在 {@link RpcContext_inner#endLocal(String, String)} 后执行的回调
	 * @param context
	 * @param localContext
	 */
	public void afterEndLocal(RpcContext_inner context, LocalContext_inner localContext) {
		// noop
	}

	/**
	 * 当前监听器被移除之后执行的回调
	 */
	public void afterListenerRemoval() {
		// noop
	}

	/**
	 * 当前监听器被注册之后执行的回调
	 */
	public void afterListenerRegister() {
		// noop
	}

	/**
	 * EagleEye 停止的时候执行的回调
	 */
	public void beforeEagleEyeShutdown() {
		// noop
	}
}
