package com.taobao.eagleeye;

import org.apache.log4j.MDC;

/**
 * 将 EagleEye 的调用上下文更新同步到 log4j MDC
 * @since 1.5.0-exported
 */
public class EagleEyeLog4jMdcUpdater extends EagleEyeContextListener {

	private static final EagleEyeLog4jMdcUpdater singleton = new EagleEyeLog4jMdcUpdater();

	private EagleEyeLog4jMdcUpdater() {
	}

	public static EagleEyeLog4jMdcUpdater getInstance() {
		return singleton;
	}

	@Override
	public void beforeSet(RpcContext_inner context) {
		if (context != null) {
			MDC.put("EAGLEEYE_TRACE_ID", context.getTraceId());
			MDC.put("EAGLEEYE_RPC_ID", context.getRpcId());
		} else {
			MDC.remove("EAGLEEYE_TRACE_ID");
			MDC.remove("EAGLEEYE_RPC_ID");
		}
	}
}
