package com.taobao.eagleeye;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * RPC 调用上下文
 * @since 1.5.0-exported
 */
public final class RpcContext_inner extends AbstractContext {

	RpcContext_inner(String _traceId, String _rpcId) {
		this(_traceId, _rpcId, null, new AtomicInteger(0), new AtomicInteger(0));
	}

	RpcContext_inner(String _traceId, String _rpcId, RpcContext_inner _parentRpc) {
		this(_traceId, _rpcId, _parentRpc, new AtomicInteger(0), new AtomicInteger(0));
	}

	RpcContext_inner(String _traceId, String _rpcId, RpcContext_inner _parentRpc, AtomicInteger _localIdx) {
		this(_traceId, _rpcId, _parentRpc, _localIdx, new AtomicInteger(0));
	}

	RpcContext_inner(String _traceId, String _rpcId, RpcContext_inner _parentRpc, AtomicInteger _localIdx,
			AtomicInteger _childRpcIdx) {
		super(_traceId, _rpcId, _localIdx);
	}

	/**
	 * 开始一次本地调用
	 *
	 * @param serviceName 接口名称
	 * @param methodName 方法名称
	 */
	public void startLocal(String serviceName, String methodName) {
	}

	/**
	 * 开始一次本地调用
	 *
	 * @param componentType 组件类型
	 * @param serviceName 接口名称
	 * @param methodName 方法名称
	 */
	public void startLocal(String componentType, String serviceName, String methodName) {
	}

	/**
	 * 本地调用结束，并设置业务状态码。如果业务状态码不是 RPC_RESULT_SUCCESS ，
	 * 则认为设置的业务状态码是表示错误的业务状态码
	 *
	 * @param bizResultCode 设置业务状态码
     * @param appendMsg 客户端日志追加的信息， 不能有回车换行等符号，可以为 <code>null</code>
	 */
	public void endLocal(String bizResultCode, String appendMsg) {
	}

	/**
	 * 本地调用结束
	 *
	 * @param resultCode 用于表明成功还是失败。
	 *             如果成功，使用RPC_RESULT_SUCCESS，如果失败，使用 RPC_RESULT_FAILED
	 * @param bizResultCode 业务的状态码（不要有可变参数在里面，因为要进行统计）
	 * @param appendMsg 客户端日志追加的信息， 不能有回车、换行、“|” 等符号
	 */
	public void endLocal(String resultCode, String bizResultCode, String appendMsg) {
	}

	/**
	 * 用于判断当前 LocalContext 是否处于激活状态（栈顶）
	 */
	public boolean isLocalContextActive() {
		return false;
	}

    /**
     * 创建子 RPC 上下文
     * @return
     */
    public RpcContext_inner createChildRpc() {
        return null;
    }

	/**
	 * 获取上一层调用上下文
	 */
	public RpcContext_inner getParentRpcContext() {
        return null;
	}

	public void startTrace(String traceName) {
    }

	public void endTrace(String resultCode, int type) {
	}

	public void startRpc(String serviceName, String methodName) {
	}

	public void endRpc(String result, int type, String appendMsg) {
	}

	public void rpcClientSend() {
    }

	public void rpcServerRecv(String serviceName, String methodName) {
    }

	public void rpcServerSend(int type, String resultCode, String appendMsg) {
	}

    public void resetTraceName(String traceName, String iToken) {
    }

	public void putUserDataXX(String key, String value) {
	}

	public void index(int type, String index, String msg) {
	}

    static void set(RpcContext_inner ctx) {
    }

    static RpcContext_inner get() {
    	return null;
    }

    /**
     * 把 RpcContext 导出为 Map 进行传输，以便网络传输时序列化可以兼容新老版本。
     * @return
     */
    public Map<String, String> toMap() {
        return null;
    }

    static RpcContext_inner fromMap(Map<String, String> map) {
        return null;
    }
}
