package com.taobao.hsf.tbremoting.invoke;

/**
 * High-Speed Service Framework (HSF)
 *
 * www.taobao.com
 *  (C) 淘宝(中国) 2003-2014
 */

import com.taobao.hsf.exception.HSFException;

import java.util.concurrent.Future;

/**
 * Future方式来获取远程返回的结果
 * 
 * 可满足并行调用的需求：每次调用后，使用getFuture获取对应的future。
 */
public class HSFResponseFuture {

    public static ThreadLocal<Future<Object>> future = new ThreadLocal<Future<Object>>();

    public static ThreadLocal<HSFFutureListener> listener = new ThreadLocal<HSFFutureListener>();

    /**
     * 获取远程对象的结果。 如果通信层抛出异常，把异常外包装HSFException。
     * <p>
     * 如果指定的时间用完但还没有收到响应，则返回
     * 
     * @param timeout
     *            超时时间
     * @throws HSFException
     * @throws InterruptedException
     */
    public static Object getResponse(long timeout) throws HSFException, InterruptedException {
        return null;
    }


    public static HSFFuture getFuture() throws HSFException {
        if (null == future.get()) {
            throw new HSFException("Thread [" + Thread.currentThread() + "] have not set the response future!");
        }

        HSFFuture hsfFuture = new HSFFuture(HSFResponseFuture.future.get());
        future.remove();
        return hsfFuture;
    }

    /**
     * 设置Future方式的调用,不需要应用调用
     * 
     */
    public static void setFuture(Future<Object> future) {
        HSFResponseFuture.future.set(future);

        if (HSFResponseFuture.listener.get() != null) {
            HSFResponseFuture.listener.get().onSetFuture();
        }
    }

    public static void setFutureListener(HSFFutureListener listener) {
        HSFResponseFuture.listener.set(listener);
    }
}
