/**
 * High-Speed Service Framework (HSF)
 * <p>
 * www.taobao.com
 * (C) 淘宝(中国) 2003-2014
 */
package com.taobao.hsf.util;

/**
 * 描述：常量
 *
 * @author <a href="mailto:bixuan@taobao.com">bixuan</a>
 * @author kongming.lrq
 */
public interface HSFConstants {

    /**
     * 标志此HSF的版本
     */
    String RPC_VERSION = "v";

    /**
     * HTTP Transport port
     */
    String HTTP_PORT = "_h";

    /**
     * HSF2.0优先使用的序列化方式，只会被2.0认出，因为2.0支持的序列化方式，1.0不能识别
     */
    String PREFER_SERIALIZIER = "_p";

    String SUPPORT_OPTIMIZED_HESSIAN = "_ih2";

    String ENABLE_OPTIMIZED_HESSIAN = "_enable_optimized_hessian";

    /**
     * 客户端最大连接数Key
     */
    String CLIENTMAXCONNECTION_KEY = "CLIENTMAXCONNECTION";

    /**
     * 客户端最小连接数Key
     */
    String CLIENTMINCONNECTION_KEY = "CLIENTMINCONNECTION";

    /**
     * 客户端最大重试获取连接次数Key
     */
    String CLIENTRETRYCONNECTIONTIMES_KEY = "CLIENTRETRYCONNECTIONTIMES";

    /**
     * 客户端重试获取连接的超时时间Key
     */
    String CLIENTRETRYCONNECTIONTIMEOUT_KEY = "CLIENTRETRYCONNECTIONTIMEOUT";

    /**
     * 消费者的性能日志默认阀值
     */
    int CONSUMER_PROFILER = 3000;

    /**
     * 提供者的性能日志默认阀值
     */
    int PROVIDER_PROFILER = 2500;

    /**
     * 序列化类型
     */
    String SERIALZETYPE_KEY = "SERIALZETYPE";

    /**
     * Hessian序列化
     */
    String HESSIAN_SERIALIZE = "hessian";

    /**
     * Hessian2序列化
     */
    String HESSIAN2_SERIALIZE = "hessian2";

    /**
     * Java序列化
     */
    String JAVA_SERIALIZE = "java";

    /**
     * kryo序列化
     */
    String KRYO_SERIALIZE = "kryo";

    /**
     * FastJson序列化
     */
    String FASTJSON_SERIALIZE = "json";

    /**
     * Customized序列化
     */
    String CUSTIMIZED_SERIALIZE = "custom";

    String[] SUPPORTED_SERIALIZER = { "kryo", "java", "hessian", "hessian2", "json", "custom" };

    /**
     * stable_switch Key
     */
    String STABLE_SWITCH = "stable_switch";

    /**
     * 未知应用名称
     */
    String UNKNOWN_APP_NAME = "UNKNOWN";

    /**
     * 设置在HSFRequest中的调用应用名称的Key
     */
    String CONSUMER_APP_NAME = "Consumer-AppName";

    /**
     * HSF日志目录标识Key
     */
    String HSF_LOG_PATH = "HSF.LOG.PATH";

    String COMPONENT_RUNTIME_INFO = "_runtime_info";

    String COMPONENT_NIOPROVIDER_SERVER = "_nio_provider_server";
    String THREADPOOL_STORE_KEY = "_threadpool";
    String METADATAS_STORE_KEY = "_metadatas";
    String WORKS_STORE_KEY = "_works";
    String WORKERMETHODS_STORE_KEY = "_workermethods";
    String WORKERFIELDS_STORE_KEY = "_workerfields";
    String LOG_METHODS_STORE_KEY = "_log_methods";

    /**
     * HSF ThreadLocal变量Key
     */
    // String TL_KEY_PROTOCOL = "_serialize_protocol";
    String TL_KEY_SERVICE_NAME = "_service_unique_name";
    String TL_KEY_METHOD_NAME = "_method_name";
    String TL_KEY_REMOTE_IP = "_remote_ip";
    // String TL_KEY_REMOTE_IP_OF_CONSUMER = "_remote_ip_c";
    String TL_KEY_METHOD_PARAMETERTYPES = "_method_parameter_types";
    String TL_KEY_HSFREQUEST = "_hsf_request";
    String TL_KEY_APPNAME_OF_CONSUMER = "_hsf_appname_c";
    String TL_KEY_TARGET_SERVER_IP = "_hsf_target_server_ip";
    String TL_KEY_REQUEST_TIMEOUT = "_hsf_request_timeout";

    /*
     * 用于特殊支持TOP和泛华调用的单元化
     */
    String KEY_UNIT_DEPLOY_USER_ID = "_hsf_unit_deploy_user_id";

    String UNIT_KEY = "unit_key";

    String TARGET_GROUP = "target_group";

    /**
     * Rule header list
     */
    String HEADER_FLOW_CONTROL_RULE = "flowControl@";
    String HEADER_ROUTING_RULE = "Groovy_v200907@";

    String PROXY_STYLE_JAVASSIST = "javassist";

    /**
     * 泛化
     */
    String GENERIC_SERIALIZATION_NATIVE_JAVA = "nativejava";
    String GENERIC_SERIALIZATION_DEFAULT = "true";
    String $INVOKE = "$invoke";

    /**
     * ECHO
     */
    String $ECHO = "$echo";

    String NULL_VERSION = "0.0.0";

    /**
     * 调用方式标识字符串
     */
    String INVOKE_TYPE_SYNC = "SYNC";
    String INVOKE_TYPE_CALL_BACK = "CALLBACK";
    String INVOKE_TYPE_FUTURE = "FUTURE";
    String INVOKE_TYPE_RELIABLE = "RELIABLE";

    String RESPONSE_CALLBACK = "T_RESPONSE_CALLBACK";

    String TARGET_SERVER_IP = "target_server_ip";
    /**
     * 安全验证的key，用于某些敏感应用的验证
     */
    String SECURE_KEY = "Secure-Key";

    String ACCESS_KEY = "Access-Key";

    String SPAS_VERSION = "Spas-Version";

    String SPAS_SIGNATURE = "Spas-Signature";

    String TIME_STAMP = "Time-Stamp";

    String CONSUMER_TIMEOUT = "Consumer-Timeout";

    String TARGET_UNIT = "target-unit";

    String ROUTE_SERVICE = "ROUTE_SERVICE";

    String ROUTE_SERVICE_RANDOM = "random";

    String ROUTE_SERVICE_CONSISTENT = "consistent";

    String CONSISTENT_KEY = "CONSISTENT_KEY";

    /**
     * <pre>
     * TB-Remoting的Key
     * <p>序列化类型，目前有三种可用的序列化协议：</p>
     * <li>1，HESSIAN协议</li>
     * <li>2，JAVA序列化协议</li>
     * <li>3，TOP应用自定义的协议</li>
     * </pre>
     */
    String TBR_SERIALIZE_TYPE_KEY = "_SERIALIZETYPE";

    /**
     * <pre>
     * TB-Remoting的Key
     * 等待超时，无论是同步还是异步
     * </pre>
     */
    String TBR_TIMEOUT_TYPE_KEY = "_TIMEOUT";

    /**
     * TOP协议格式
     */
    byte TBR_TOP_SERIALIZE = 3;

    //edas
    String INVOKE_PROTOCOL_TYPE_KEY = "service.invoke.type";
    String INVOKE_PROTOCOL_TYPE_DUBBO = "DUBBO";
    String INVOKE_PROTOCOL_TYPE_HSF = "HSF";
    String INVOKE_PROTOCOL_TYPE_ALL_1 = "DUBBO,HSF";
    String INVOKE_PROTOCOL_TYPE_ALL_2 = "HSF,DUBBO";

    /**
     * 环境变量租户ID
     */
    String TENANT_ID = "_TID";


    /**
     * containerid的配置，一般通过-D参数配置
     */
    String CONTAINER_ID = "JM.CONTAINER.ID";
    /**
     * 附着在地址URL中的key
     */
    String CONTAINER_ID_KEY = "_CONTAINERID";

    /**
     * 客户端传过来的是否移除泛化调用输出中的class信息
     */
    String REMOVE_CLASS = "REMOVE_CLASS";


    String NETWORK_ENV="_ENV";

    /**
     * Mtop去中心化在服务端使用的userId
     */
    String KEY_UNIT_PROVIDER_USER_ID = "_hsf_unit_provider_user_id";
    String TL_KEY_DIRECT_TARGET_SERVER_IP = "_hsf_direct_target_server_ip";

    String SERIALIZE_TYPE_KEY = "_SERIALIZETYPE";

    /**
     * 等待超时，无论是同步还是异步
     */
    String TIMEOUT_TYPE_KEY = "_TIMEOUT";

    /**
     * 连接读空闲超时Key。单位：秒。
     */
    String IDLE_TIMEOUT_KEY = "_IDLETIMEOUT";

    /**
     * 机房在URL上的key
     */
    String SITE_KEY = "st";

    String HTTP_REQUEST = "HTTP_REQUEST";
}
