package com.alibaba.dts.client;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

import com.alibaba.dts.client.executor.job.context.ClientContext;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.FailureJobProcessor;
import com.alibaba.dts.client.executor.job.processor.StopJobProcessor;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.LoggerCleaner;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.GroupIdUtil;
import com.alibaba.dts.common.util.PathUtil;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.edas.schedulerx.SchedulerXLogLevel;
import com.taobao.common.fulllinkstresstesting.SplitEnvUtil;

/**
 * DTS客户端初始化入口
 *
 * @author tianyao.myc
 * @deprecated replaced by {@link SchedulerxClient}
 */
@Deprecated
public class DtsClient implements ApplicationContextAware, ApplicationListener, Constants,ClientService {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(DtsClient.class);

    private final ClientContextImpl clientContext = new ClientContextImpl();

    private static final ConcurrentHashMap<String, Boolean> clientTable = new ConcurrentHashMap<String, Boolean>();

    private static Object lock = new Object();

    private static SchedulerXLogLevel defaultLogLevel = SchedulerXLogLevel.WARN;

    private static SchedulerXLogLevel executeLogLevel = SchedulerXLogLevel.WARN;

    //日志清理
    private LoggerCleaner loggerCleaner = new LoggerCleaner(PathUtil.getLoggerPath());

    /**
     * Spring最后初始化
     */
    @Override
    public void onApplicationEvent(ApplicationEvent event) {

        if (!(event instanceof ContextRefreshedEvent)) {
            return;
        }

        if (!clientContext.getClientConfig().isAutoInit()) {
            logger.warn("[SchedulerXClient]: do not AutoInit, clientConfig:" + clientContext.getClientConfig());
            return;
        }

        try {
            init();
        } catch (Throwable e) {
            String info = "[SchedulerXClient]: init error, clientConfig:" + clientContext.getClientConfig();
            logger.error(info, e);
            throw new RuntimeException(info, e);
        }

    }

    /**
     * 初始化
     *
     *  com.alibaba.dts.common.exception.InitException
     */
    public void init() throws InitException {

        SchedulerXLoggerFactory.initLogByLevel(defaultLogLevel.getInformation(), executeLogLevel.getInformation());

        /** 客户端各项参数配置初始化 */
        clientContext.getClientConfig().init();

        if (!Constants.ENVIRONMENT_SCX.equals(clientContext.getClientConfig().getEnvironment())) {
            if (!Constants.ENVIRONMENT_PRIVATE_CLOUD.equals(clientContext.getClientConfig().getEnvironment())) {
                if (!SplitEnvUtil.needStartDtsOnlyByEnv()) {
                    logger.error("[SchedulerXClient]: init error, because of isolation environment");
                    return;
                }
            }
        }


        if (Constants.ENVIRONMENT_SCX.equals(clientContext.getClientConfig().getEnvironment())) {

            //初使化httpHead
            if (clientContext.getClientConfig().getInnerDebug() == 1) {
                clientContext.getHttpService().setUseHttps(false);
            } else {
                clientContext.getHttpService().setUseHttps(true);
            }

            //初使化groupID
            if (StringUtil.isEmpty(clientContext.getClientConfig().getGroupId())) {
                initGroupId(clientContext.getClientConfig().getServiceGroup(), clientContext.getClientConfig().getRegionName(), clientContext.getClientConfig().getServiceGroupId());

            }
        }

        /** 检查分组ID */
        GroupIdUtil.checkGroupId(clientContext.getClientConfig().getGroupId());

        synchronized (lock) {

            logger.warn("[SchedulerXClient]: tell initialized"
                    + ", thread:" + Thread.currentThread().getName()
                    + ", groupId:" + clientContext.getClientConfig().getGroupId());

            Boolean init = clientTable.get(clientContext.getClientConfig().getGroupId());

            if (null == init) {
                clientTable.put(clientContext.getClientConfig().getGroupId(), new Boolean(true));
            } else {
                logger.warn("SchedulerXClient has already initialized"
                        + ", thread:" + Thread.currentThread().getName()
                        + ", groupId:" + clientContext.getClientConfig().getGroupId());
                return;
            }

        }

        if (Constants.ENVIRONMENT_SCX.equals(clientContext.getClientConfig().getEnvironment())) {
            clientContext.getSecurityCheck().init();
        }

        /** 客户端远程通信初始化 */
        clientContext.getClientRemoting().init();

        /** 初始化Job处理器工厂 */
        if (!clientContext.getClientConfig().isAgent()) {
            clientContext.getJobProcessorFactory().init();
        }

        if (clientContext.getClientConfig().isAgent()) {
            //初始化日志清理
            loggerCleaner.init(); //是SchedulerX-Agent就启动日志清理
        }

        logger.warn("[SchedulerXClient]: init over, clientConfig:" + clientContext.getClientConfig().toString());
    }

    public void initGroupId(String serviceGroup, String regionName, String serviceGroupId) throws InitException {

        if (StringUtil.isBlank(serviceGroupId)) {
            throw new InitException("[InitGroupId]: serviceGroupId  is null!");
        }

        if (StringUtil.isBlank(serviceGroup) || StringUtil.isBlank(regionName)) {
            throw new InitException("[InitGroupId]: serviceGroup or regionName is null!");
        }

        if (StringUtil.isBlank(serviceGroup) || StringUtil.isBlank(regionName)) {
            throw new InitException("[InitGroupId]: serviceGroup or regionName is null!");
        }
        Result<String> result = clientContext.getHttpService().acquireGroupID(this.clientContext.getClientConfig().getDomainName(), serviceGroupId, regionName);
        if (result.getResultCode() == null) {
            throw new InitException("[InitGroupId]: get groupid error, return null!");
        }

        if (result.getResultCode() != ResultCode.SUCCESS) {
            throw new InitException("[InitGroupId]: get groupid error," + result.getResultCode().getInformation());
        }
        if (StringUtil.isEmpty(result.getData())) {
            throw new InitException("[InitGroupId]: get groupid error," + result.getResultCode().getInformation());
        } else {
            clientContext.getClientConfig().setGroupId(result.getData());
        }
    }

    /**
     * 远程通信服务线程数量
     *
     *  remotingThreads
     */
    public void setRemotingThreads(int remotingThreads) {
        clientContext.getClientConfig().setRemotingThreads(remotingThreads);
    }

    /**
     * 心跳间隔时间
     *
     *  heartBeatIntervalTime
     */
    public void setHeartBeatIntervalTime(long heartBeatIntervalTime) {
        clientContext.getClientConfig().setHeartBeatIntervalTime(heartBeatIntervalTime);
    }

    /**
     * 连接超时时间
     *
     *  connectionTimeout
     */
    public void setConnectionTimeout(long connectionTimeout) {
        clientContext.getClientConfig().setConnectionTimeout(connectionTimeout);
    }

    /**
     * 分组ID
     *
     *  groupId
     */
    public void setGroupId(String groupId) {
        clientContext.getClientConfig().setGroupId(groupId);
    }

    /**
     * ZK地址列表
     *
     *  zkHosts
     */
    public void setZkHosts(String zkHosts) {
        clientContext.getClientConfig().setZkHosts(zkHosts);
    }

    /**
     * ZK根目录
     *
     *  namespace
     */
    public void setNamespace(String namespace) {
        clientContext.getClientConfig().setNamespace(namespace);
    }

    /**
     * ZK会话超时时间
     *
     *  zkSessionTimeout
     */
    public void setZkSessionTimeout(int zkSessionTimeout) {
        clientContext.getClientConfig().setZkSessionTimeout(zkSessionTimeout);
    }

    /**
     * ZK连接超时时间
     *
     *  zkConnectionTimeout
     */
    public void setZkConnectionTimeout(int zkConnectionTimeout) {
        clientContext.getClientConfig().setZkConnectionTimeout(zkConnectionTimeout);
    }

    /**
     * 队列大小
     *
     *  queueSize
     */
    public void setQueueSize(int queueSize) {
        clientContext.getClientConfig().setQueueSize(queueSize);
    }

    /**
     * 消费线程数量
     *
     *  consumerThreads
     */
    public void setConsumerThreads(int consumerThreads) {
        clientContext.getClientConfig().setConsumerThreads(consumerThreads);
    }

    /**
     * 消费线程数量Map
     *
     *  consumerThreadsMap
     */
    public void setConsumerThreadsMap(Map<String, Integer> consumerThreadsMap) {
        clientContext.getClientConfig().setConsumerThreadsMap(consumerThreadsMap);
    }

    /**
     * 一次从服务端拉取的任务数量
     *
     *  pageSize
     */
    public void setPageSize(int pageSize) {
        clientContext.getClientConfig().setPageSize(pageSize);
    }

    /**
     * 一次从服务端拉取的任务数量Map
     *
     *  pageSizeMap
     */
    public void setPageSizeMap(Map<String, Integer> pageSizeMap) {
        clientContext.getClientConfig().setPageSizeMap(pageSizeMap);
    }

    /**
     * 访问键
     *
     *  accessKey
     */
    public void setAccessKey(String accessKey) {
        clientContext.getClientConfig().setAccessKey(accessKey);
    }

    public void setSecretKey(String secretKey) {
        clientContext.getClientConfig().setSecretKey(secretKey);
    }

    /**
     * 宕机重试
     *
     *  crashRetry
     */
    public void setCrashRetry(boolean crashRetry) {
        clientContext.getClientConfig().setCrashRetry(crashRetry);
    }

    public void setZkHostsAutoChange(boolean zkHostsAutoChange) {
        clientContext.getClientConfig().setZkHostsAutoChange(zkHostsAutoChange);
    }

    /**
     * 空队列暂停拉取间隔时间
     *
     *  pullTaskListOverSleepTime
     */
    public void setPullTaskListOverSleepTime(long pullTaskListOverSleepTime) {
        clientContext.getClientConfig().setPullTaskListOverSleepTime(pullTaskListOverSleepTime);
    }

    public void setFailureJobProcessorMap(Map<String, FailureJobProcessor> failureJobProcessorMap) {
        clientContext.getClientConfig().setFailureJobProcessorMap(failureJobProcessorMap);
    }

    public void setFinishLog(boolean finishLog) {
        clientContext.getClientConfig().setFinishLog(finishLog);
    }

    public void setStopJobProcessor(StopJobProcessor stopJobProcessor) {
        clientContext.getClientConfig().setStopJobProcessor(stopJobProcessor);
    }

    public void setEveryTimeNew(boolean isEveryTimeNew) {
        clientContext.getClientConfig().setEveryTimeNew(isEveryTimeNew);
    }

    public void setEnvironment(String environment) {
        clientContext.getClientConfig().setEnvironment(environment);
    }

    public void setServiceGroup(String serviceGroup) {
        clientContext.getClientConfig().setServiceGroup(serviceGroup);
    }

    public void setServiceGroupId(String serviceGroupId) {
        clientContext.getClientConfig().setServiceGroupId(serviceGroupId);
    }

    public void setRegionName(String regionName) {
        clientContext.getClientConfig().setRegionName(regionName);
    }

    public void setInnerDebug(int innerDebug) {
        clientContext.getClientConfig().setInnerDebug(innerDebug);
    }

    public void setDomainName(String domainName) {
        if (StringUtil.isBlank(domainName) || "default".equals(domainName)) {
            return;
        }
        clientContext.getClientConfig().setDomainName(domainName);
    }

    public void setAutoInit(boolean autoInit) {
        clientContext.getClientConfig().setAutoInit(autoInit);
    }

    public ClassLoader getCustomerClassLoader() {
        return clientContext.getProxyService().getCustomerClassLoader();
    }

    public void setCustomerClassLoader(ClassLoader customerClassLoader) {
        clientContext.getProxyService().setCustomerClassLoader(customerClassLoader);
    }

    public SchedulerXLogLevel getExecuteLogLevel() {
        return executeLogLevel;
    }

    public void setExecuteLogLevel(SchedulerXLogLevel executeLogLevel) {
        this.executeLogLevel = executeLogLevel;
    }

    public SchedulerXLogLevel getDefaultLogLevel() {
        return defaultLogLevel;
    }

    public void setDefaultLogLevel(SchedulerXLogLevel defaultLogLevel) {
        this.defaultLogLevel = defaultLogLevel;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext)
            throws BeansException {

        //设置Spring上下文
        clientContext.getJobProcessorFactory().setApplicationContext(applicationContext);

        //设置Spring
        clientContext.getClientConfig().setSpring(true);
        logger.warn("[SchedulerXClient]: setApplicationContext over, applicationContext:" + applicationContext);
    }

    public ClientContext getClientContext() {
        return clientContext;
    }

    public void setNewInstance(boolean newInstance) {
        clientContext.getClientConfig().setNewInstance(newInstance);
    }

    public void stopService(){

        try{
            clientTable.remove(clientContext.getClientConfig().getGroupId());

            if (clientContext.getClientConfig().isAgent()) {
                loggerCleaner.stop();
            }

            clientContext.getClientConfig().removeDataListener();

            clientContext.getClientRemoting().stopService();

            clientContext.getExecutor().stopService();

            logger.info("[SchedulerXClient]: stopService success!");

        }catch (Exception e){
            logger.error("[SchedulerXClient]: stopService error." ,e);
        }
    }

    /**
     * SchedulerX-Agent程序启动入口
     *
     *  arguments
     */
    public static void main(String[] arguments) {
        DtsClient dtsClient = new DtsClient();//创建DtsClient
        //设置SchedulerX-Agent方式启动
        dtsClient.getClientContext().getClientConfig().setAgent(true);

        /** 设置INI配置文件路径 */
        dtsClient.getClientContext().getClientConfig().setConfigPath(arguments[0]);

        try {
            dtsClient.init();//初始化DtsClient
        } catch (Throwable e) {
            logger.error("[SchedulerX-Agent]: main init error"
                    + ", clientConfig:" + dtsClient.getClientContext().getClientConfig()
                    + ", arguments:" + Arrays.toString(arguments), e);

            //启动失败退出进程
            System.exit(0);
        }

        logger.warn("[SchedulerX-Agent]: main init over"
                + ", clientConfig:" + dtsClient.getClientContext().getClientConfig()
                + ", arguments:" + Arrays.toString(arguments));
    }

}
