package com.alibaba.dts.client.config;

import java.util.Map;

import com.alibaba.dts.client.executor.grid.flowcontrol.FlowControlStrategy;
import com.alibaba.dts.client.route.RouteRule;
import com.alibaba.dts.client.store.StoreStrategy;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.util.PathUtil;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.common.util.StringUtil;

/**
 * Created by yif on 16/8/31.
 */
public class NodeConfig implements Constants {

    /**
     * 监听端口
     */
    private int listenPort = 60000;
    private int systemListenPort = listenPort + 100;

    private String localAddress;

    private long connectTime;

    private long connectTimeout = DEFAULT_CONNECTION_TIMEOUT;

    /**
     * 远程通信服务线程数量
     */
    private int remotingThreads = 8;

    private String groupId;

    private long heartbeatInterval = DEFAULT_HEART_BEAT_INTERVAL_TIME;

    /**
     * h2 storage file path;
     */
//    private String dbPath = "~/.h2/";
    private String dbPath = PathUtil.getH2Path();


    /**
     * receive queue buffer size, must be set as pow(2, x);
     */
    private int receiveBufferSize = 1024 * 1024;

    private boolean dispatchOnly = false;

    private FlowControlStrategy flowControlStrategy = FlowControlStrategy.NONE;

    private int taskInsertBatchSize = 0;

    private String environment;

    /**
     * RouteRule Map
     */
    private Map<String, RouteRule> routeMap;

    private Map<String, FlowControlStrategy> flowControlStrategyMap;

    private StoreStrategy storeStrategy = StoreStrategy.DISK;

    private boolean enableRedispatch;

    public int getListenPort() {
        return listenPort;
    }

    public void setListenPort(int listenPort) {
        if (listenPort >= 1024 && listenPort <= 65435) {
            this.listenPort = listenPort;
            this.systemListenPort = listenPort + 100;
        }
    }

    public String getLocalAddress() {
        if (StringUtil.isBlank(localAddress)) {
            this.localAddress = RemotingUtil.getLocalAddress(Constants.ENVIRONMENT_SCX.equals(environment)) + Constants.COLON + this.listenPort;
        }
        return localAddress;
    }

    public void setLocalAddress(String localAddress) {
        if (StringUtil.isNotBlank(localAddress)) {
            this.localAddress = localAddress;
        } else {
            this.localAddress = RemotingUtil.getLocalAddress(Constants.ENVIRONMENT_SCX.equals(environment)) + Constants.COLON + this.listenPort;
        }
    }

    public int getRemotingThreads() {
        return remotingThreads;
    }

    public void setRemotingThreads(int remotingThreads) {
        this.remotingThreads = remotingThreads;
    }

    public long getConnectTimeout() {
        return connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getConnectTime() {
        return connectTime;
    }

    public void setConnectTime(long connectTime) {
        this.connectTime = connectTime;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public long getHeartbeatInterval() {
        return heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public String getDbPath() {
        return dbPath;
    }

    public void setDbPath(String dbPath) {
        this.dbPath = dbPath;
    }

    public int getReceiveBufferSize() {
        return receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public Map<String, RouteRule> getRouteMap() {
        return routeMap;
    }

    public void setRouteMap(Map<String, RouteRule> routeMap) {
        this.routeMap = routeMap;
    }

    public boolean isDispatchOnly() {
        return dispatchOnly;
    }

    public void setDispatchOnly(boolean dispatchOnly) {
        this.dispatchOnly = dispatchOnly;
    }

    public FlowControlStrategy getFlowControlStrategy() {
        return flowControlStrategy;
    }

    public void setFlowControlStrategy(FlowControlStrategy flowControlStrategy) {
        this.flowControlStrategy = flowControlStrategy;
    }

    public void setTaskInsertBatchSize(int taskInsertBatchSize) {
        this.taskInsertBatchSize = taskInsertBatchSize;
    }

    public int getTaskInsertBatchSize() {
        return taskInsertBatchSize;
    }

    public StoreStrategy getStoreStrategy() {
        return storeStrategy;
    }

    public void setStoreStrategy(StoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
    }

    public int getSystemListenPort() {
        return systemListenPort;
    }

    public void setSystemListenPort(int systemListenPort) {
        if (systemListenPort >= 1024 && systemListenPort <= 65535) {
            this.systemListenPort = systemListenPort;
        }
    }

    public boolean isEnableRedispatch() {
        return enableRedispatch;
    }

    public void setEnableRedispatch(boolean enableRedispatch) {
        this.enableRedispatch = enableRedispatch;
    }

    public Map<String, FlowControlStrategy> getFlowControlStrategyMap() {
        return flowControlStrategyMap;
    }

    public void setFlowControlStrategyMap(
        Map<String, FlowControlStrategy> flowControlStrategyMap) {
        this.flowControlStrategyMap = flowControlStrategyMap;
    }

    public String getEnvironment() {
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Override
    public String toString() {
        return "NodeConfig{" +
            "listenPort=" + listenPort +
            ", systemListenPort=" + systemListenPort +
            ", localAddress='" + localAddress + '\'' +
            ", connectTime=" + connectTime +
            ", connectTimeout=" + connectTimeout +
            ", remotingThreads=" + remotingThreads +
            ", groupId='" + groupId + '\'' +
            ", heartbeatInterval=" + heartbeatInterval +

            ", dbPath='" + dbPath + '\'' +
            ", receiveBufferSize=" + receiveBufferSize +
            ", dispatchOnly=" + dispatchOnly +
            ", flowControlStrategy=" + flowControlStrategy +
            ", taskInsertBatchSize=" + taskInsertBatchSize +
            ", routeMap=" + routeMap +
            ", flowControlStrategyMap=" + flowControlStrategyMap +
            ", storeStrategy=" + storeStrategy +
            ", enableRedispatch=" + enableRedispatch +
            ", environment=" + environment +
            '}';
    }
}
