package com.alibaba.dts.client.executor.grid;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.remoting.ChannelEventListener;
import com.alibaba.dts.common.remoting.netty.NettyServerConfig;
import com.alibaba.dts.common.remoting.netty.NodeNettyRemotingServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;

import java.net.BindException;
import java.net.InetSocketAddress;

/**
 * Created by yif on 2017/7/6.
 */
public class ClientNodeRemotingServer extends NodeNettyRemotingServer {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ClientNodeRemotingServer.class);

    private ClientContextImpl clientContext;

    public ClientNodeRemotingServer(NettyServerConfig nettyServerConfig, ClientContextImpl clientContext) {
        super(nettyServerConfig);
        this.clientContext = clientContext;
    }

    public ClientNodeRemotingServer(NettyServerConfig nettyServerConfig, ChannelEventListener channelEventListener, ClientContextImpl clientContext) {
        super(nettyServerConfig, channelEventListener);
        this.clientContext = clientContext;
    }

    @Override
    public void boot(ServerBootstrap serverBootstrap) {
        try {
            boolean bindSuccess = false;
            while (!bindSuccess) {
                int listenPort = clientContext.getNodeConfig().getListenPort();
                try {
                    ChannelFuture sync = serverBootstrap.bind(listenPort);
                    sync.sync();
                    bindSuccess = true;
                    InetSocketAddress addr = (InetSocketAddress) sync.channel().localAddress();
                    this.port = addr.getPort();
                } catch (Exception e) {
                    if (e instanceof BindException) {
                        logger.warn(e.getMessage() + ", port=" + listenPort + ", we will try a new port");
                        listenPort = listenPort + 1;
                        if (listenPort > 65535) {
                            listenPort = 40000;
                        }
                        clientContext.getNodeConfig().setListenPort(listenPort);
                    } else if (e instanceof InterruptedException) {
                        throw (InterruptedException) e;
                    } else {
                        throw new RuntimeException(e);
                    }
                }
            }
        } catch (InterruptedException e1) {
            throw new RuntimeException("this.serverBootstrap.bind().sync() InterruptedException", e1);
        }
    }
}
