package com.alibaba.dts.client.executor.grid;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yif on 16/10/10.
 */
public class GridPool implements Constants {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(GridPool.class);

    private ClientContextImpl clientContext;

    public GridPool(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void stopService(){
          //TODO:add grid job stop service code
    }

    public boolean executeTask(ExecutableTask executableTask) {

        Result<Boolean> result = clientContext.getNodeServerServiceLocal().receiveTasks(executableTask);
        return result.getData();

    }

    /**
     * 停止任务
     *
     *  jobId
     *  jobInstanceId
     *
     */
    public boolean stopTask(long jobId, long jobInstanceId) {

        return clientContext.getNodeServerServiceLocal().stopTask(jobId, jobInstanceId);
    }

    public Result<String> heartBeatCheckJobInstance(long jobId, long jobInstanceId) {

        return new Result<String>();
    }
}
