package com.alibaba.dts.client.executor.grid.flowcontrol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.context.JobContext;

/**
 * Created by yif on 2016/12/22.
 */
public class FlowControlChain {

    private ClientContextImpl clientContext;

    private List<FlowControl> flowControls = new ArrayList<FlowControl>();

    private Map<String, FlowControl> flowControlMap = new HashMap<String, FlowControl>();

    public FlowControlChain(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void init() {
        FlowControlStrategy flowControlStrategy = clientContext.getNodeConfig().getFlowControlStrategy();
        FlowControlParameterWatcher watcher = new FlowControlParameterWatcher(clientContext);
        watcher.watchH2Count();

        FlowControl h2Count = new H2CountOneFlowControl(clientContext);

        if (clientContext.getNodeConfig().getFlowControlStrategyMap() != null) {
            for (Entry<String, FlowControlStrategy> jobProcessorFlowControlStrategy : clientContext.getNodeConfig()
                .getFlowControlStrategyMap().entrySet()) {
                String jobProcessor = jobProcessorFlowControlStrategy.getKey();
                FlowControlStrategy flowControlStrategyTemp = jobProcessorFlowControlStrategy.getValue();
                if (flowControlStrategyTemp == FlowControlStrategy.H2_COUNT_ONE || flowControlStrategyTemp
                    == FlowControlStrategy.H2_COUNT) {
                    flowControlMap.put(jobProcessor, h2Count);
                }
            }
        }
        if (flowControlStrategy == FlowControlStrategy.NONE) {
            return;
        }
        if (flowControlStrategy == FlowControlStrategy.H2_COUNT_ONE || flowControlStrategy
            == FlowControlStrategy.H2_COUNT) {
            addLast(h2Count);
        }
    }

    public void control(JobContext jobContext) {
        String jobProcessor = jobContext.getJob().getJobProcessor();
        FlowControl flowControl = flowControlMap.get(jobProcessor);
        if (flowControl != null) {
            flowControl.pass(jobContext);
        } else {
            for (FlowControl flowControl2 : flowControls) {
                flowControl2.pass(jobContext);
            }
        }
    }

    public void addLast(FlowControl flowControl) {
        flowControls.add(flowControl);
    }

    public List<FlowControl> getFlowControls() {
        return flowControls;
    }

    public void setFlowControls(List<FlowControl> flowControls) {
        this.flowControls = flowControls;
    }
}
