package com.alibaba.dts.client.executor.grid.processor;

import java.util.List;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.service.ServerService;
import com.alibaba.dts.common.util.BytesUtil;
import com.alibaba.dts.common.util.BytesUtil4Client;

/**
 * Created by yif on 16/10/12.
 */
public class GridJobContextImpl extends JobContextImpl implements Constants,GridJobContext {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(GridJobContextImpl.class);


    /**
     * 当前要处理的任务快照
     */
    private TaskSnapshot taskSnapshot;

    /**
     * 当前要处理的任务
     */
    private Object task;

    /**
     * 任务名称
     */
    private String taskName;

    //可用的机器数量
    private int availableMachineAmount;

    //当前机器编号
    private int currentMachineNumber;

    private ServerService serverService;

    private ClientContextImpl clientContext;

    public GridJobContextImpl(final ClientContextImpl clientContext, Job job, JobInstanceSnapshot jobInstanceSnapshot, int retryCount) {
        super(job, jobInstanceSnapshot, retryCount);
        this.clientContext = clientContext;
        this.serverService = this.clientContext.getClientRemoting().proxyInterface(ServerService.class);
    }

    public Object getTask() {
        return task;
    }

    public String getTaskName() {
        return taskName;
    }

    /**
     * 设置任务
     *
     *  taskSnapshot
     */
    public void setTask(TaskSnapshot taskSnapshot) {
        this.taskSnapshot = taskSnapshot;
        this.taskName = taskSnapshot.getTaskName();
        if (DEFAULT_ROOT_LEVEL_TASK_NAME.equals(taskSnapshot.getTaskName())) {
            if (BytesUtil.isEmpty(taskSnapshot.getBody())) {
                logger.error("[GridJobContext]: BytesUtil setTask bytesToObject error, body is empty"
                        + ", instanceId:" + taskSnapshot.getJobInstanceId()
                        + ", id:" + taskSnapshot.getId());
                return;
            }
            try {
                this.task = BytesUtil.bytesToObject(taskSnapshot.getBody());
            } catch (Throwable e) {
                logger.error("[GridJobContext]: BytesUtil setTask bytesToObject error"
                        + ", instanceId:" + taskSnapshot.getJobInstanceId()
                        + ", id:" + taskSnapshot.getId(), e);
            }
        } else {
            if (BytesUtil4Client.isEmpty(taskSnapshot.getBody())) {
                logger.error("[GridJobContext]: BytesUtil4Client setTask bytesToObject error, body is empty"
                        + ", instanceId:" + taskSnapshot.getJobInstanceId()
                        + ", id:" + taskSnapshot.getId());
                return;
            }
            try {
                this.task = BytesUtil4Client.bytesToObject(taskSnapshot.getBody());
            } catch (Throwable e) {
                logger.error("[GridJobContext]: BytesUtil4Client setTask bytesToObject error"
                        + ", instanceId:" + taskSnapshot.getJobInstanceId()
                        + ", id:" + taskSnapshot.getId(), e);
            }
        }
    }

    /**
     * 初始化重试次数
     *
     *  retryCount
     */
    public void initRetryCount(int retryCount) {
        super.setRetryCount(retryCount);
    }

    /**
     * 分发任务列表
     *
     *  taskList 任务列表
     *  taskName 任务名称
     *
     */
    public Result<Boolean> dispatchTaskList(List<? extends Object> taskList, String taskName) {
        Result<Boolean> result = clientContext.getGridTaskSender().dispatchTaskList(taskList, taskName, this);

        return result;
    }

    public TaskSnapshot getTaskSnapshot() {
        return taskSnapshot;
    }
}
