package com.alibaba.dts.client.executor.grid.processor;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.GridJobProcessor;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yif on 16/10/11.
 */
public class GridTaskProcessor implements Runnable, Constants {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(GridTaskProcessor.class);

    private ClientContextImpl clientContext;

    private ExecutableTask executableTask;

    private TaskSnapshot taskSnapshot;

    /**
     * Grid计算上下文
     */
    private GridJobContextImpl context;

    public GridTaskProcessor(ClientContextImpl clientContext, ExecutableTask executableTask,
                             TaskSnapshot taskSnapshot) {
        this.clientContext = clientContext;
        this.executableTask = executableTask;
        this.taskSnapshot = taskSnapshot;
        this.context = new GridJobContextImpl(clientContext, executableTask.getJob(),
                executableTask.getJobInstanceSnapshot(), executableTask.getJobInstanceSnapshot().getRetryCount());
    }

    @Override
    public void run() {
        GridJobProcessor gridJobProcessor = null;
        try {
            if (clientContext.getGridTaskSender().isInterruptedInstance(
                    executableTask.getJobInstanceSnapshot().getId())) {
                return;
            }
            gridJobProcessor = clientContext.getJobProcessorFactory().createAndGetGridJobProcessor(
                    executableTask.getJob(), false);
        } catch (Throwable e) {
            logger.error(
                    "createAndGetGridJobProcessor error, jobProcessor:" + executableTask.getJob().getJobProcessor(), e);
        }
        executeTask(gridJobProcessor, taskSnapshot);
    }

    private void executeTask(GridJobProcessor gridJobProcessor, TaskSnapshot taskSnapshot) {
        if (null == gridJobProcessor) {

            logger.error("jobProcessor is null , please check " + executableTask.getJob().getJobProcessor());

            if (DEFAULT_ROOT_LEVEL_TASK_NAME.equals(taskSnapshot.getTaskName())) {
                clientContext.getExecutor().acknowledge(taskSnapshot, TASK_STATUS_FAILURE, 0);
            } else {
                clientContext.getExecutor().acknowledgeNode(taskSnapshot, TASK_STATUS_FAILURE, 0);
            }
            return;
        }

        /** 任务开始 计数器加一 */
        //        this.status = TASK_PROCESSOR_STATUS_RUNNING;
        //        this.threadCounter.incrementAndGet();

        try {
            /** 设置任务 */
            context.setTask(taskSnapshot);

            //初始化重试次数
            context.initRetryCount(taskSnapshot.getRetryCount());

            ProcessResult processResult = null;
            try {
                processResult = gridJobProcessor.process(context);
            } catch (Throwable e) {

                logger.error("[GridTaskProcessor]: process error"
                        + ", instanceId:" + taskSnapshot.getJobInstanceId()
                        + ", id:" + taskSnapshot.getId(), e);

            }

            if (null == processResult) {

                logger.error("[GridTaskProcessor]: process error, processResult is null"
                        + ", instanceId:" + taskSnapshot.getJobInstanceId()
                        + ", id:" + taskSnapshot.getId());
                processResult = new ProcessResult(false);

            }

            /** 处理重试次数 */
            handleRetryCount(taskSnapshot, processResult);

            String taskName = context.getTaskName();
            //            if(taskSnapshot.isCompensation()) {
            //                if (DEFAULT_ROOT_LEVEL_TASK_NAME.equals(taskName)) {
            //                    clientContext.getExecutor().acknowledgeCompensation(taskSnapshot, processResult
            // .isSuccess() ? TASK_STATUS_SUCCESS : TASK_STATUS_FAILURE, processResult.getRetryCount());
            //                } else {
            //                    clientContext.getExecutor().acknowledgeCompensationNode(taskSnapshot, processResult
            // .isSuccess() ? TASK_STATUS_SUCCESS : TASK_STATUS_FAILURE, processResult.getRetryCount());
            //                }
            //            } else {
            if (DEFAULT_ROOT_LEVEL_TASK_NAME.equals(taskName)) {
                clientContext.getExecutor().acknowledge(taskSnapshot,
                        processResult.isSuccess() ? TASK_STATUS_SUCCESS : TASK_STATUS_FAILURE,
                        processResult.getRetryCount());
            } else {
                clientContext.getExecutor().acknowledgeNode(taskSnapshot,
                        processResult.isSuccess() ? TASK_STATUS_SUCCESS : TASK_STATUS_FAILURE,
                        processResult.getRetryCount());
            }
            //            }

        } catch (Throwable e) {
            logger.error("[GridTaskProcessor]: executeTask error"
                    + ", instanceId:" + taskSnapshot.getJobInstanceId()
                    + ", id:" + taskSnapshot.getId(), e);
        } finally {
            /** 任务结束 计数器减一 */
        }

    }

    /**
     * 处理重试次数
     * <p>
     * taskSnapshot
     * processResult
     */
    private void handleRetryCount(TaskSnapshot taskSnapshot, ProcessResult processResult) {

        /** 如果是执行成功就不设置重试 */
        if (processResult.isSuccess()) {
            processResult.setRetryCount(0);
            return;
        }

        /** 如果是补偿任务就重试次数减一 */
        if (taskSnapshot.isCompensation()) {
            if (taskSnapshot.getRetryCount() > 0) {
                processResult.setRetryCount(taskSnapshot.getRetryCount() - 1);
            } else {
                processResult.setRetryCount(0);
            }
            return;
        }

        /** 不能超过最大重试次数 */
        if (processResult.getRetryCount() > MAX_RETRY_COUNT) {
            processResult.setRetryCount(MAX_RETRY_COUNT);
            return;
        }
    }
}
