package com.alibaba.dts.client.executor.grid.queue.receive;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

import com.alibaba.dts.client.executor.grid.processor.GridTaskProcessor;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yif on 2016/12/14.
 */
public class TaskReceiveHandler {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskReceiveHandler.class);

    private ClientContextImpl clientContext;

    private Map<Long, ExecutorService> executorServiceMap = new ConcurrentHashMap<Long, ExecutorService>();


    public TaskReceiveHandler(ClientContextImpl clientContext, Map<Long, ExecutorService> executorServiceMap) {
        this.clientContext = clientContext;
        this.executorServiceMap = executorServiceMap;
    }

    public void listen(final BlockingQueue<ExecutableTask> taskReceiveBuffer) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                while (true) {
                    try {
                        ExecutableTask executableTask = null;
                        try {
                            executableTask = taskReceiveBuffer.take();
                            if (clientContext.getGridTaskSender().isInterruptedInstance(
                                executableTask.getJobInstanceSnapshot().getId())) {
                                logger.warn("[TaskReceiveHandler]: force interrupt:"
                                    + ",jobId:" + executableTask.getJob().getId()
                                    + ",jobInstanceId:" + executableTask.getJobInstanceSnapshot().getId()
                                    + ",total tasks:" + executableTask.getTaskSnapshotList().size()
                                );
                                continue;
                            }
                        } catch (InterruptedException e) {
                            logger.warn("executableTask is interrupted");
                            continue;
                        }
                        if (executableTask == null) {
                            logger.warn("executableTask is null");
                            continue;
                        }
                        ExecutorService executorService = executorServiceMap.get(executableTask.getJobInstanceSnapshot().getId());
                        if (executorService == null || executorService.isTerminated() || executorService.isShutdown()) {
                            logger.warn("executorservice is null or terminated, {}", executableTask);
                            continue;
                        }

                        TaskSnapshot taskSnapshot = executableTask.getTaskSnapshot();
                        if (taskSnapshot != null) {
                            GridTaskProcessor gridTaskProcessor = new GridTaskProcessor(clientContext, executableTask, taskSnapshot);
                            Future<?> future = executorService.submit(gridTaskProcessor);
                        } else {
                            List<TaskSnapshot> tasks = executableTask.getTaskSnapshotList();
                            for (TaskSnapshot task : tasks) {
                                task.setSendNodeAddress(executableTask.getSendNodeAddress());
                                GridTaskProcessor gridTaskProcessor = new GridTaskProcessor(clientContext, executableTask, task);
                                Future<?> future = executorService.submit(gridTaskProcessor);
                            }
                        }
                    } catch (Throwable throwable) {
                        logger.error("ExecutableTask receive process error", throwable);
                    }
                }
            }
        }).start();
    }

}
