package com.alibaba.dts.client.executor.grid.queue.send;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

import com.alibaba.dts.client.executor.grid.queue.TaskEvent;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.context.JobContext;
import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.client.route.RouteRule;
import com.alibaba.dts.client.route.impl.RoundRobinRule;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

import org.springframework.util.CollectionUtils;

/**
 * Created by yif on 2017/4/10.
 */
public class TaskRouter implements Runnable {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskRouter.class);

    private SendManager sendManager;
    private Map<String, RouteRule> routeMap;
    private RouteRule routeRule = new RoundRobinRule();

    public TaskRouter(ClientContextImpl clientContext, SendManager sendManager) {
        this.sendManager = sendManager;
        routeMap = clientContext.getNodeConfig().getRouteMap();
    }

    @Override
    public void run() {
        BlockingQueue<TaskEvent> routeQueue = sendManager.getRouteQueue();
        BlockingQueue<TaskEvent> mergeQueue = sendManager.getMergeQueue();
        while (true) {
            TaskEvent taskEvent = null;
            try {
                taskEvent = routeQueue.take();
                if (sendManager.isInterruptedJobInstance(
                    taskEvent.getExecutableTask().getJobInstanceSnapshot().getId())) {
                    logger.debug("job instance interrupted, jobId=" + taskEvent.getExecutableTask().getJob().getId()
                        + ", jobInstanceId=" + taskEvent.getExecutableTask().getJobInstanceSnapshot().getId()
                        + ", taskId=" + taskEvent.getExecutableTask().getTaskSnapshot().getId());
                    continue;
                }
                try {
                    List<RemoteMachine> machines = sendManager.getMachinesByJob().get(
                        taskEvent.getExecutableTask().getJob().getId());
                    if (routeMap != null && !CollectionUtils.isEmpty(routeMap)) {
                        RouteRule tryAcquireRouteRule = routeMap.get(
                            taskEvent.getExecutableTask().getJob().getJobProcessor());
                        if (tryAcquireRouteRule != null) {
                            routeRule = tryAcquireRouteRule;
                        }
                    } else {
                        logger.debug("[TaskRouter] routeMap is null!"
                            + ",jobID:" + taskEvent.getExecutableTask().getJob().getId()
                            + ",jobInstanceID:" + taskEvent.getExecutableTask().getJobInstanceSnapshot().getId());
                    }

                    JobContext jobContext = new JobContextImpl();
                    jobContext.setJob(taskEvent.getExecutableTask().getJob());
                    jobContext.setJobInstanceSnapshot(taskEvent.getExecutableTask().getJobInstanceSnapshot());
                    jobContext.setRouteTask(taskEvent.getTask());

                    RemoteMachine remoteMachine = routeRule.rule(jobContext, machines);

                    if (remoteMachine == null) {
                        logger.error("[TaskRouter] RoutePreProcess error,targetMachine is null!"
                            + ",jobID:" + taskEvent.getExecutableTask().getJob().getId()
                            + ",jobInstanceID:" + taskEvent.getExecutableTask().getJobInstanceSnapshot().getId());
                    }

                    taskEvent.setTargetMachine(remoteMachine);
                    mergeQueue.put(taskEvent);

                    logger.debug("[TaskRouter] RoutePreProcess,remoteMachine:" + remoteMachine
                        + ",jobID:" + taskEvent.getExecutableTask().getJob().getId()
                        + ",jobInstanceID:" + taskEvent.getExecutableTask().getJobInstanceSnapshot().getId());

                } catch (Throwable e) {
                    logger.error("[TaskRouter] RoutePreProcess error:"
                        + ",jobID:" + taskEvent.getExecutableTask().getJob().getId()
                        + ",jobInstanceID:" + taskEvent.getExecutableTask().getJobInstanceSnapshot().getId(), e);
                }

            } catch (Throwable e) {
                logger.error("failed to route task, task=" + taskEvent);
            }
        }
    }

}
