package com.alibaba.dts.client.executor.grid.timer;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.store.access.ExecutionCounterDao;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yif on 2016/10/19.
 */
public class ExecutionCounterDeleteTimer {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ExecutionCounterUpdateTimer.class);

    private ClientContextImpl clientContext;

    private ExecutionCounterDao executionCounterDao;

    public ExecutionCounterDeleteTimer(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
        executionCounterDao = clientContext.getStore().getExecutionCounterDao();
    }

    public void init() {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable() {
            @Override
            public void run() {
                try {

                    List<String> servers = clientContext.getClientRemoting().getServerList();

                    if (servers == null || servers.isEmpty()) {
                        logger.warn("server list is null or empty");
                        return;
                    }

                    List<Long> jobInstanceIds = executionCounterDao.listJobInstances();
                    if (jobInstanceIds == null || jobInstanceIds.isEmpty()) {
                        logger.warn("jobInstanceIds is null or empty");
                        return;
                    }


                    for (Long jobInstanceId : jobInstanceIds) {
                        try {
                            JobInstanceSnapshot jobInstanceSnapshot = null;
                            for (String server : servers) {
                                InvocationContext.setRemoteMachine(new RemoteMachine(server, 10 * 1000));

                                Result<JobInstanceSnapshot> result = clientContext.getServerService().getJobInstanceById(jobInstanceId);
                                if (result == null) {
                                    logger.error("getJobInstanceById error, jobInstanceId = {}, server= {}", jobInstanceId, server);
                                    continue;
                                }

                                if (!Constants.SUCCESS.equals(result.getResultCode())) {
                                    logger.error("getJobInstanceById error, jobInstanceId = {}, server= {}, errorCode = ", jobInstanceId, server, result.getResultCode());
                                    continue;
                                }
                                jobInstanceSnapshot = result.getData();
                                break;

                            }

                            //if jobInstanceSnapshot is null, we take it as deleted by server, for it is finished, so we need to delete
                            //the execution counters associated with the given job instance id
                            if (jobInstanceSnapshot == null) {
                                executionCounterDao.deleteByJobInstanceId(jobInstanceId);
                                return;
                            }

                            int status = jobInstanceSnapshot.getStatus();
                            if (/*status == Constants.JOB_INSTANCE_STATUS_FINISHED
                                    ||*/ status == Constants.JOB_INSTANCE_STATUS_FAILED
                                    || status == Constants.JOB_INSTANCE_STATUS_DELETE_SELF)
                                executionCounterDao.deleteByJobInstanceId(jobInstanceId);
                        } catch (Throwable e) {
                            logger.error("delete execution counter error, jobInstanceId = {}", jobInstanceId, e);
                        }
                    }

                } catch (Throwable throwable) {
                    logger.error(throwable.getMessage(), throwable);
                }
            }
        }, 0, 10 * 60, TimeUnit.SECONDS);
    }


}
