package com.alibaba.dts.client.executor.grid.timer;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.exception.AccessException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.NamedThreadFactory;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class HealthChecker {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(HealthChecker.class);

    public static volatile AtomicBoolean h2Alive = new AtomicBoolean(true);

    public static volatile AtomicLong failCounter = new AtomicLong();

    private ClientContextImpl clientContext;

    private ScheduledThreadPoolExecutor HealthCheckThreadPool = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("SchedulerX-H2-Health-Check-Thread-"));

    public HealthChecker(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void init() {
        HealthCheckThreadPool.scheduleAtFixedRate(new Runnable() {
            @Override
            public void run() {
                try {
                    clientContext.getStore().getCommonDao().healthCheck();
                    h2Alive.set(true);
                    failCounter.set(0);
                } catch (AccessException e) {
                    h2Alive.set(false);
                    long count = failCounter.addAndGet(1);
                    if (count % 10 == 0) {
                        logger.error("healthCheck error", e);
                    }
                }
            }
        }, 0, 10, TimeUnit.SECONDS);
    }

}
