package com.alibaba.dts.client.executor.job.context;


import java.util.concurrent.ConcurrentHashMap;

import com.alibaba.dts.client.config.ClientConfig;
import com.alibaba.dts.client.config.ClientConfigImpl;
import com.alibaba.dts.client.config.NodeConfig;
import com.alibaba.dts.client.executor.Executor;
import com.alibaba.dts.client.executor.grid.GridTaskSender;
import com.alibaba.dts.client.executor.grid.IdWorker;
import com.alibaba.dts.client.executor.grid.flowcontrol.FlowControlChain;
import com.alibaba.dts.client.executor.grid.timer.*;
import com.alibaba.dts.client.executor.job.factory.JobProcessorFactory;
import com.alibaba.dts.client.executor.logcollector.AbstractLogCleaner;
import com.alibaba.dts.client.executor.logcollector.LogCollectorFactory;
import com.alibaba.dts.client.logger.ExecuteLogger;
import com.alibaba.dts.client.remoting.ClientRemoting;
import com.alibaba.dts.client.remoting.NodeRemoting;
import com.alibaba.dts.client.remoting.proxy.ClientInvocationHandler;
import com.alibaba.dts.client.security.SecurityCheck;
import com.alibaba.dts.client.service.ClientServiceImpl;
import com.alibaba.dts.client.service.NodeServerServiceImpl;
import com.alibaba.dts.client.store.Store;
import com.alibaba.dts.client.zookeeper.Zookeeper;
import com.alibaba.dts.common.domain.store.ExecutionCounter;
import com.alibaba.dts.common.proxy.ProxyService;
import com.alibaba.dts.common.service.ClientService;
import com.alibaba.dts.common.service.HttpService;
import com.alibaba.dts.common.service.NodeClientService;
import com.alibaba.dts.common.service.NodeServerService;
import com.alibaba.dts.common.service.ServerService;

/**
 * 客户端全局上下文
 * 可以放置全局使用的类
 *
 * @author tianyao.myc
 */
public class ClientContextImpl implements ClientContext {

    /**
     * 客户端各项参数配置
     */
    private final ClientConfig clientConfig = new ClientConfigImpl(this);

    /**
     * 代理服务
     */
    private final ProxyService proxyService = new ProxyService();

    /**
     * 客户端远程通信
     */
    private final ClientRemoting clientRemoting = new ClientRemoting(this);

    private NodeRemoting nodeRemoting = new NodeRemoting(this);

    private Store store = new Store(this);

    /**
     * 服务端通用基础服务
     */
    private NodeServerServiceImpl nodeServerServiceLocal = new NodeServerServiceImpl(this);

    /**
     * 客户端通用基础服务
     */
    private final ClientService clientService = new ClientServiceImpl(this);

    private final ServerService serverService = proxyService.proxyInterface(ServerService.class, new ClientInvocationHandler(this));

    private final NodeServerService nodeServerService = nodeRemoting.getNodeServerService();

    private final NodeServerService nodeServerSystemService = nodeRemoting.getNodeServerSystemService();
    private final NodeClientService nodeClientService = nodeRemoting.getNodeClientService();

    /**
     * Zookeeper
     */
    private final Zookeeper zookeeper = new Zookeeper(this);

    /**
     * SecurityCheck
     */
    private final SecurityCheck securityCheck = new SecurityCheck(this);

    /**
     * Job处理器工厂
     */
    private final JobProcessorFactory jobProcessorFactory = new JobProcessorFactory(this);

    /**
     * 执行任务容器
     */
    private final Executor executor = new Executor(this);

    /**
     * execution counter table
     * <p>
     * first key: job instance id
     * <p>
     * second key: node which receives and processes the dispatched tasks with format of 10.0.0.1:55001
     */
//    private ConcurrentHashMap<Long, ConcurrentHashMap<String, ExecutionCounter>> executionCounterTable = new ConcurrentHashMap<Long, ConcurrentHashMap<String, ExecutionCounter>>();
    private ConcurrentHashMap<Long /*job instance id*/, ConcurrentHashMap<String /*receive node*/, ConcurrentHashMap<String /*task name*/, ExecutionCounter>>> executionCounterTable = new ConcurrentHashMap<Long, ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>>();

    private GridTaskSender gridTaskSender = new GridTaskSender(this);

    private FlowControlChain flowControlChain = new FlowControlChain(this);
    private HealthChecker healthChecker = new HealthChecker(this);


    /**
     *
     */
    private ExecutionCounterUpdateTimer executionCounterUpdateTimer = new ExecutionCounterUpdateTimer(this);
    private ExecutionCounterDeleteTimer executionCounterDeleteTimer = new ExecutionCounterDeleteTimer(this);
    private TaskDeleteTimer taskDeleteTimer = new TaskDeleteTimer(this);
    private CompensationTimer compensationTimer = new CompensationTimer(this);
    private IdWorker idWorker = new IdWorker(0, 0);
    private AbstractLogCleaner logCleaner = LogCollectorFactory.newCleaner();


    //执行日志
    private final ExecuteLogger executeLogger = new ExecuteLogger();

    private final HttpService httpService = new HttpService();

    public NodeConfig nodeConfig = new NodeConfig();


    public ClientConfig getClientConfig() {
        return clientConfig;
    }

    public ProxyService getProxyService() {
        return proxyService;
    }

    public ClientRemoting getClientRemoting() {
        return clientRemoting;
    }

    public ClientService getClientService() {
        return clientService;
    }

    public Zookeeper getZookeeper() {
        return zookeeper;
    }

    public SecurityCheck getSecurityCheck() {
        return securityCheck;
    }

    public JobProcessorFactory getJobProcessorFactory() {
        return jobProcessorFactory;
    }

    public Executor getExecutor() {
        return executor;
    }

    public ExecuteLogger getExecuteLogger() {
        return executeLogger;
    }

    public HttpService getHttpService() {
        return httpService;
    }

    public NodeConfig getNodeConfig() {
        return nodeConfig;
    }

    public NodeServerServiceImpl getNodeServerServiceLocal() {
        return nodeServerServiceLocal;
    }

    public NodeServerService getNodeServerService() {
        return nodeServerService;
    }

    public NodeRemoting getNodeRemoting() {
        return nodeRemoting;
    }

    public ServerService getServerService() {
        return serverService;
    }

    public Store getStore() {
        return store;
    }

    public ConcurrentHashMap<Long, ConcurrentHashMap<String, ConcurrentHashMap<String, ExecutionCounter>>> getExecutionCounterTable() {
        return executionCounterTable;
    }

    public GridTaskSender getGridTaskSender() {
        return gridTaskSender;
    }

    public ExecutionCounterUpdateTimer getExecutionCounterUpdateTimer() {
        return executionCounterUpdateTimer;
    }

    public ExecutionCounterDeleteTimer getExecutionCounterDeleteTimer() {
        return executionCounterDeleteTimer;
    }

    public TaskDeleteTimer getTaskDeleteTimer() {
        return taskDeleteTimer;

    }

    public CompensationTimer getCompensationTimer() {
        return compensationTimer;
    }

    public IdWorker getIdWorker() {
        return idWorker;
    }

    public FlowControlChain getFlowControlChain() {
        return flowControlChain;
    }

    public Object getNodeClientService() {
        return nodeClientService;
    }

    public AbstractLogCleaner getLogCleaner() {
        return logCleaner;
    }

    @Override
    public boolean doHealthCheck() {

        boolean result=true;
        if (clientRemoting.getServerList()==null || clientRemoting.getServerList().isEmpty()){
            result = false;
        }
        return result;
    }

    public HealthChecker getHealthChecker() {
        return healthChecker;
    }
}
