package com.alibaba.dts.client.executor.longtime.processor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.longtime.LongTimePool;
import com.alibaba.dts.client.executor.longtime.unit.ExecutorUnit;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;


public class ReFillingProcessor extends Thread implements Constants {

	private static final Logger logger = SchedulerXLoggerFactory.getLogger(ReFillingProcessor.class);

	/** 执行单元 */
	private ExecutorUnit executorUnit;

	/** 是否停止拉取线程 */
	private volatile boolean stop = true;

	private static final long REFILL_SLEEP_TIME_INTERVAL= 1 *1000;
	private static final long REFILL_PULLANDPUT_TIME_INTERVAL= 100;

	private final ClientContextImpl clientContext;

	public ReFillingProcessor(final ClientContextImpl clientContext,ExecutorUnit executorUnit) {
		this.clientContext = clientContext;
		this.executorUnit = executorUnit;

		super.setName(REFILLING_TASK_THREAD_NAME + this.executorUnit.getExecutableTask().getJob().getId()
				+ HORIZONTAL_LINE +  executorUnit.getExecutableTask().getJob().getJobProcessor() 
				+ HORIZONTAL_LINE +  executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() 
				+ HORIZONTAL_LINE +  executorUnit.getExecutableTask().getJobInstanceSnapshot().getFireTime() 
				+ HORIZONTAL_LINE +  executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount());
	}
	
	/**
	 * 刷新线程信息
	 *  executorUnit
	 */
	public void refresh(ExecutorUnit executorUnit) {
		this.executorUnit = executorUnit;
		super.setName(REFILLING_TASK_THREAD_NAME + this.executorUnit.getExecutableTask().getJob().getId()
				+ HORIZONTAL_LINE +  executorUnit.getExecutableTask().getJob().getJobProcessor() 
				+ HORIZONTAL_LINE +  executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() 
				+ HORIZONTAL_LINE +  executorUnit.getExecutableTask().getJobInstanceSnapshot().getFireTime() 
				+ HORIZONTAL_LINE +  executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount());
	}
	
	@Override
	public void run() {
		try {

			this.stop=false;
			BlockingQueue<TaskSnapshot> queue = this.executorUnit.getQueue();
			BlockingQueue<TaskSnapshot> completeQueue = this.executorUnit.getCompletedqueue();

			while(! stop) {

				if (!isPause()){
					try {
						Thread.sleep(REFILL_PULLANDPUT_TIME_INTERVAL);
					} catch (Throwable e) {
						logger.error("[RefillingProcessor]:  RefillingProcessor sleep error"
								+ ", instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
					}
					try {
						pullAndPut(queue,completeQueue);
					} catch (Throwable e) {
						logger.error("[RefillingProcessor]: pullAndPut error"
								+ ", instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
					}
				}else{
					try {
						Thread.sleep(REFILL_SLEEP_TIME_INTERVAL);
					} catch (Throwable e) {
						logger.error("[RefillingProcessor]:  RefillingProcessor sleep error"
								+ ", instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
					}
				}

			}

		} catch (Throwable e) {
			logger.error("[RefillingProcessor]: run error"
					+ ", instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
		} finally {
			try {
				LongTimePool longTimePool = executorUnit.getLongTimePool();
				longTimePool.stopTask(this.executorUnit.getExecutableTask().getJob().getId(),
						this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
			} catch (Throwable e) {
				logger.error("[RefillingProcessor]: finally stopTask error"
						+ ", instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
			} finally {
				if(this.clientContext.getClientConfig().isFinishLog()) {
					logger.warn("[RefillingProcessor]: finally stopTask"
							+ ", instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
				}
			}
		}
	}

	private boolean isPause(){
		return (this.executorUnit.isReleaseTaskFlag() || this.executorUnit.isPullTaskFlag());
	}

	private String isPausePrint(){
		return "isReleaseTaskFlag:"+this.executorUnit.isReleaseTaskFlag()+",isPullTaskFlag:"+this.executorUnit.isPullTaskFlag();
	}

	/**
	 * 拉取任务列表并放入队列
	 *  queue
	 */
	private void pullAndPut(BlockingQueue<TaskSnapshot> queue,BlockingQueue<TaskSnapshot> completeQueue) {

		while(!isPause() && !completeQueue.isEmpty()) {
			TaskSnapshot taskSnapshot = null;

			try {
				taskSnapshot = completeQueue.poll(DEFAULT_POLL_TIMEOUT, TimeUnit.MILLISECONDS);
				logger.info("[ReFillingProcessor]: completeQueue poll success"
								+ ", instanceId:" + taskSnapshot.getJobInstanceId()
								+ ", taskid:" + taskSnapshot.getId()
				);
			} catch (Throwable e) {
				logger.error("[RefillingProcessor]: take executableTask error"
						+ ", instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
			}
			if(null == taskSnapshot) {
				continue ;
			}

			try {
				queue.put(taskSnapshot);
				logger.info("[ReFillingProcessor]: queue put success"
						+ ", instanceId:" + taskSnapshot.getJobInstanceId()
						+ ", taskid:" + taskSnapshot.getId()
				);
			} catch (Throwable e) {
				logger.error("[RefillingProcessor]: put error"
						+ ", instanceId:" + taskSnapshot.getJobInstanceId()
						+ ", id:" + taskSnapshot.getId(), e);
			}
		}
	}
	
	public boolean isStop() {
		return stop;
	}

	public void setStop(boolean stop) {
		this.stop = stop;
	}

}
