package com.alibaba.dts.client.executor.longtime.unit;

import java.util.*;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.longtime.LongTimePool;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * Created by yanshan.sy on 2016/10/25.
 */
public class StatesReportTimer extends TimerTask {

    private final ExecutorUnit executorUnit;

    private final ClientContextImpl clientContext;

    private static final long TASK_CHECK_PERIOD = 2 * 60 * 1000L;

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(StatesReportTimer.class);

    public StatesReportTimer(ExecutorUnit executorUnit, ClientContextImpl clientContext) {
        this.executorUnit = executorUnit;
        this.clientContext = clientContext;
    }

    @Override
    public void run() {
        try
        {

            Result<JobInstanceSnapshot> jobInstanceStates = clientContext.getExecutor().getJobInstanceById(executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());

            if (jobInstanceStates!=null && jobInstanceStates.getResultCode()== ResultCode.SUCCESS){

                if(null == jobInstanceStates.getData() || Constants.JOB_INSTANCE_STATUS_RUNNING != jobInstanceStates.getData().getStatus()) {
                    //实例已经结束，中止运行
                    LongTimePool longTimePool = executorUnit.getLongTimePool();
                    longTimePool.stopTask(this.executorUnit.getExecutableTask().getJob().getId(),
                            this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());

                    this.executorUnit.stopTask();//补偿停止

                    logger.warn("[StatesReportTimer]: current jobInstance has been stop"
                                    + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId()
                    );

                }else {

                    Result<Boolean> taskStatesReportResult = null;
                    List<Long> ids = getIdList(executorUnit.getTaskRunStatisticMap());

                    if (ids==null || ids.isEmpty()){
                        logger.warn("TaskRunStatisticMap is empty, instanceId:"+executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
                    }else{
                        taskStatesReportResult =clientContext.getExecutor().taskStatesReport(executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(),ids);
                        if(null == taskStatesReportResult || ! taskStatesReportResult.getData().booleanValue()) {
                            logger.warn("[StatesReportTimer]: taskStatesReport error"
                                    + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId()
                                    + ", ids:" + ids
                                    + ", taskStatesReportResult:" + taskStatesReportResult);
                        } else {
                            logger.info("[StatesReportTimer]: taskStatesReport successful"
                                    + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId()
                                    + ", ids:" + ids
                                    + ", taskStatesReportResult:" + taskStatesReportResult);
                        }
                    }

                    logger.info("[StatesReportTimer]: current statistic detail"
                                    + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId()
                                    + ", current queue size:" + executorUnit.getQueue().size()
                                    + ", current queue:" + getQueueTaskid(executorUnit.getQueue())
                                    + ", current completed queue size:" + executorUnit.getCompletedqueue().size()
                                    + ", current completed queue:" + getQueueTaskid(executorUnit.getCompletedqueue())
                                    + ", current taskRunStatisticMap size:" + executorUnit.getTaskRunStatisticMap().size()
                                    + ", current taskRunStatisticMap:" + executorUnit.getTaskRunStatisticMapStr()
                    );

                }

            }else{
                //实例已经结束，中止运行
                LongTimePool longTimePool = executorUnit.getLongTimePool();
                longTimePool.stopTask(this.executorUnit.getExecutableTask().getJob().getId(),
                        this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());

                this.executorUnit.stopTask();//补偿停止

                logger.warn("[StatesReportTimer]: current jobInstance has been stop"
                                + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId()
                );
            }


        } catch (Throwable e) {
            logger.error("[StatesReportTimer]: taskStatesReport error"
                    + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
        }
    }

    private String getQueueTaskid(BlockingQueue<TaskSnapshot> taskSnapshots){
        StringBuffer ids = new StringBuffer();
        try{
            TaskSnapshot[] taskSnapshotArrayList = null;
             if (taskSnapshots!=null){
                taskSnapshotArrayList =  new TaskSnapshot[taskSnapshots.size()];
                taskSnapshots.toArray(taskSnapshotArrayList);
            }
            ids.append("[");
            if (taskSnapshotArrayList!=null){
                for (int i=0; i<taskSnapshotArrayList.length;i++){
                    ids.append(","+taskSnapshotArrayList[i].getId());
                }
            }
            ids.append("]");
        }catch (Throwable e){
            logger.error("[StatesReportTimer]: getQueueTaskid error"
                    + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
        }
        return ids.toString();
    }

    private List<Long> getIdList(ConcurrentHashMap<Long, TaskRunStatistic> taskSnapshotList) {

        List<Long> result = null;
        try{
            if (taskSnapshotList==null || taskSnapshotList.isEmpty()){
                return null;
            }

            result = new ArrayList<Long>();

            Iterator iterator = taskSnapshotList.entrySet().iterator();
            while(iterator.hasNext()) {

                try{

                    Date now = new Date();
                    Date checkTime = new Date(now.getTime() - TASK_CHECK_PERIOD);

                    Map.Entry entry = (Map.Entry)iterator.next();
                    Long taskid = (Long)entry.getKey();
                    TaskRunStatistic taskRunStatistic = (TaskRunStatistic) entry.getValue();
                    if (taskRunStatistic!=null && (taskRunStatistic.getLastRunTime().compareTo(checkTime)>0)){
                        result.add(taskid);
                    }else{
                        logger.warn("[StatesReportTimer]: task lastRunTimeout"
                                + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId()
                                + ", checkTime:"+checkTime
                                + ", lastRunTime:"+taskRunStatistic.getLastRunTime()
                                + ", taskid:" + taskid);
                    }
                }catch(Throwable e){
                    logger.error("[StatesReportTimer]: getIdList error"
                            + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
                }
            }


        }catch (Throwable e){
            logger.error("[StatesReportTimer]: getIdList error"
                    + ", instanceId:" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
        }
        return result;
    }
}
