package com.alibaba.dts.client.executor.parallel.processor;


import com.alibaba.dts.client.executor.job.processor.FailureJobProcessor;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * 默认失败任务处理器
 * @author tianyao.myc
 *
 */
public class DefaultFailureJobProcessor implements FailureJobProcessor {

	private static final Logger logger = SchedulerXLoggerFactory.getLogger(DefaultFailureJobProcessor.class);
	
	/**
	 * 处理失败任务，这里只是打印日志
	 */
	@Override
	public void process(FailureJobContext context) {
		logger.error("Task:" + context.getTask() + " process failed"
				+ ", jobId:" + context.getJob().getId() 
				+ ", instanceId:" + context.getJobInstanceSnapshot().getId() 
				+ ", fireTime:" + context.getJobInstanceSnapshot().getFireTime() 
				+ ", retryCount:" + context.getRetryCount(), context.getE());
	}


}
